/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.ConflictAction;
import org.jetbrains.idea.svn.conflict.ConflictOperation;
import org.jetbrains.idea.svn.conflict.ConflictReason;
import org.jetbrains.idea.svn.conflict.ConflictVersion;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class TreeConflictDescription
extends BaseNodeDescription {
    private final File myPath;
    private final ConflictAction myConflictAction;
    private final ConflictReason myConflictReason;
    private final ConflictOperation myOperation;
    private final ConflictVersion mySourceLeftVersion;
    private final ConflictVersion mySourceRightVersion;

    @Nullable
    public static TreeConflictDescription create(@Nullable SVNTreeConflictDescription conflict) {
        TreeConflictDescription result = null;
        if (conflict != null) {
            result = new TreeConflictDescription(conflict.getPath(), NodeKind.from(conflict.getNodeKind()), ConflictAction.from(conflict.getConflictAction().getName()), ConflictReason.from(conflict.getConflictReason().getName()), ConflictOperation.from(conflict.getOperation().getName()), ConflictVersion.create(conflict.getSourceLeftVersion()), ConflictVersion.create(conflict.getSourceRightVersion()));
        }
        return result;
    }

    public TreeConflictDescription(File path, @NotNull NodeKind nodeKind, ConflictAction conflictAction, ConflictReason conflictReason, ConflictOperation operation, ConflictVersion sourceLeftVersion, ConflictVersion sourceRightVersion) {
        if (nodeKind == null) {
            TreeConflictDescription.$$$reportNull$$$0(0);
        }
        super(nodeKind);
        this.myPath = path;
        this.myConflictAction = conflictAction;
        this.myConflictReason = conflictReason;
        this.myOperation = operation;
        this.mySourceLeftVersion = sourceLeftVersion;
        this.mySourceRightVersion = sourceRightVersion;
    }

    public boolean isTextConflict() {
        return false;
    }

    public boolean isPropertyConflict() {
        return false;
    }

    public boolean isTreeConflict() {
        return true;
    }

    public File getPath() {
        return this.myPath;
    }

    public ConflictAction getConflictAction() {
        return this.myConflictAction;
    }

    public ConflictReason getConflictReason() {
        return this.myConflictReason;
    }

    @NotNull
    public NodeKind getNodeKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            TreeConflictDescription.$$$reportNull$$$0(1);
        }
        return nodeKind;
    }

    public ConflictOperation getOperation() {
        return this.myOperation;
    }

    public ConflictVersion getSourceLeftVersion() {
        return this.mySourceLeftVersion;
    }

    public ConflictVersion getSourceRightVersion() {
        return this.mySourceRightVersion;
    }

    @NotNull
    public String toPresentableString() {
        String string = "local " + (Object)((Object)this.getConflictReason()) + ", incoming " + (Object)((Object)this.getConflictAction()) + " upon " + (Object)((Object)this.getOperation());
        if (string == null) {
            TreeConflictDescription.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeKind";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/conflict/TreeConflictDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/conflict/TreeConflictDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

