/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffAction;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.tmatesoft.svn.core.SVNURL;

public class SvnLazyPropertyContentRevision
extends SvnBaseContentRevision
implements PropertyRevision {
    private final VcsRevisionNumber myNumber;
    private final SVNURL myUrl;
    private List<PropertyData> myContent;

    public SvnLazyPropertyContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, VcsRevisionNumber number, SVNURL url) {
        if (vcs == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(1);
        }
        super(vcs, file);
        this.myNumber = number;
        this.myUrl = url;
    }

    @Override
    @Nullable
    public List<PropertyData> getProperties() throws VcsException {
        if (this.myContent == null) {
            this.myContent = this.loadContent();
        }
        return this.myContent;
    }

    public String getContent() throws VcsException {
        return ShowPropertiesDiffAction.toSortedStringPresentation(this.getProperties());
    }

    private List<PropertyData> loadContent() throws VcsException {
        Ref ref = new Ref();
        Ref exceptionRef = new Ref();
        Runnable runnable = () -> {
            try {
                ref.set(ShowPropertiesDiffAction.getPropertyList(this.myVcs, this.myUrl, ((SvnRevisionNumber)this.myNumber).getRevision()));
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, SvnBundle.message("progress.title.loading.file.properties", new Object[0]), true, this.myVcs.getProject());
            if (!completed) {
                throw new VcsException("Properties load for revision " + this.getRevisionNumber().asString() + " was canceled.");
            }
        } else {
            runnable.run();
        }
        if (!exceptionRef.isNull()) {
            throw (VcsException)((Object)exceptionRef.get());
        }
        return (List)ref.get();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myNumber;
        if (vcsRevisionNumber == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(2);
        }
        return vcsRevisionNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

