/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.xml;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlTagInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.XmlAttributePanel;
import org.intellij.plugins.intelliLang.inject.config.ui.XmlTagPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    public static final String XML_SUPPORT_ID = "xml";

    private static boolean isMine(PsiLanguageInjectionHost host) {
        if (host instanceof XmlAttributeValue) {
            PsiElement p = host.getParent();
            if (p instanceof XmlAttribute) {
                String s = ((XmlAttribute)p).getName();
                return !"xmlns".equals(s) && !s.startsWith("xmlns:");
            }
        } else if (host instanceof XmlText) {
            XmlTag tag = ((XmlText)host).getParentTag();
            return tag != null;
        }
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        if (XML_SUPPORT_ID == null) {
            XmlLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return XML_SUPPORT_ID;
    }

    @Override
    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{XmlPatterns.class};
        if (classArray == null) {
            XmlLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    @Override
    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof XmlElement;
    }

    @Override
    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<PsiElement> commentRef) {
        if (host == null) {
            XmlLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        if (host instanceof XmlAttributeValue) {
            return null;
        }
        return InjectorUtils.findCommentInjection(host instanceof XmlText ? host.getParent() : host, this.getId(), commentRef);
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!XmlLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        String id = language.getID();
        if (psiElement instanceof XmlAttributeValue) {
            return XmlLanguageInjectionSupport.doInjectInAttributeValue((XmlAttributeValue)psiElement, id);
        }
        if (psiElement instanceof XmlText) {
            return XmlLanguageInjectionSupport.doInjectInXmlText((XmlText)psiElement, id);
        }
        return false;
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost host) {
        return this.removeInjection((PsiElement)host);
    }

    @Override
    public boolean removeInjection(PsiElement host) {
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance(project);
        ArrayList<BaseInjection> injections = XmlLanguageInjectionSupport.collectInjections(host, configuration);
        if (injections.isEmpty()) {
            return false;
        }
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (BaseInjection injection : injections) {
            BaseInjection newInjection = injection.copy();
            newInjection.setPlaceEnabled(null, false);
            if (InjectorUtils.canBeRemoved(newInjection)) continue;
            newInjections.add(newInjection);
        }
        configuration.replaceInjectionsWithUndo(project, newInjections, injections, Collections.emptyList());
        return true;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost host) {
        BaseInjection newInjection;
        if (!XmlLanguageInjectionSupport.isMine(host)) {
            return false;
        }
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance(project);
        ArrayList<BaseInjection> injections = XmlLanguageInjectionSupport.collectInjections((PsiElement)host, configuration);
        if (injections.isEmpty()) {
            return false;
        }
        BaseInjection originalInjection = injections.get(0);
        BaseInjection xmlInjection = XmlLanguageInjectionSupport.createFrom(originalInjection);
        BaseInjection baseInjection = newInjection = xmlInjection == null ? XmlLanguageInjectionSupport.showDefaultInjectionUI(project, originalInjection.copy()) : XmlLanguageInjectionSupport.showInjectionUI(project, xmlInjection);
        if (newInjection != null) {
            configuration.replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), Collections.singletonList(originalInjection), Collections.emptyList());
        }
        return true;
    }

    @Nullable
    private static BaseInjection showInjectionUI(Project project, BaseInjection xmlInjection) {
        AbstractInjectionPanel panel;
        DialogBuilder builder = new DialogBuilder(project);
        if (xmlInjection instanceof XmlTagInjection) {
            panel = new XmlTagPanel((XmlTagInjection)xmlInjection, project);
            builder.setHelpId("reference.settings.injection.language.injection.settings.xml.tag");
        } else if (xmlInjection instanceof XmlAttributeInjection) {
            panel = new XmlAttributePanel((XmlAttributeInjection)xmlInjection, project);
            builder.setHelpId("reference.settings.injection.language.injection.settings.xml.attribute");
        } else {
            throw new AssertionError();
        }
        panel.reset();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(() -> {
            panel.apply();
            builder.getDialogWrapper().close(0);
        });
        if (builder.show() == 0) {
            return xmlInjection.copy();
        }
        return null;
    }

    @Nullable
    private static BaseInjection createFrom(BaseInjection injection) {
        AbstractTagInjection result;
        if (injection.getInjectionPlaces().length == 0 || injection.getInjectionPlaces().length > 1) {
            return null;
        }
        InjectionPlace place = injection.getInjectionPlaces()[0];
        ElementPattern<PsiElement> rootPattern = place.getElementPattern();
        ElementPatternCondition rootCondition = rootPattern.getCondition();
        Class elementClass = rootCondition.getInitialCondition().getAcceptedClass();
        if (XmlAttribute.class.equals((Object)elementClass)) {
            result = new XmlAttributeInjection().copyFrom(injection);
        } else if (XmlTag.class.equals((Object)elementClass)) {
            result = new XmlTagInjection().copyFrom(injection);
        } else {
            return null;
        }
        result.setInjectionPlaces(InjectionPlace.EMPTY_ARRAY);
        for (PatternCondition condition : rootCondition.getConditions()) {
            String value = XmlLanguageInjectionSupport.extractValue(condition);
            if ("withLocalName".equals(condition.getDebugMethodName())) {
                if (value == null) {
                    return null;
                }
                if (result instanceof XmlAttributeInjection) {
                    ((XmlAttributeInjection)result).setAttributeName(value);
                    continue;
                }
                result.setTagName(value);
                continue;
            }
            if ("withNamespace".equals(condition.getDebugMethodName())) {
                if (value == null) {
                    return null;
                }
                if (result instanceof XmlAttributeInjection) {
                    ((XmlAttributeInjection)result).setAttributeNamespace(value);
                    continue;
                }
                result.setTagNamespace(value);
                continue;
            }
            if (result instanceof XmlAttributeInjection && condition instanceof PatternConditionPlus) {
                boolean strict = "withParent".equals(condition.getDebugMethodName());
                if (!strict && !"inside".equals(condition.getDebugMethodName())) {
                    return null;
                }
                result.setApplyToSubTags(!strict);
                ElementPattern insidePattern = ((PatternConditionPlus)condition).getValuePattern();
                if (!XmlTag.class.equals((Object)insidePattern.getCondition().getInitialCondition().getAcceptedClass())) {
                    return null;
                }
                for (PatternCondition insideCondition : insidePattern.getCondition().getConditions()) {
                    String tagValue = XmlLanguageInjectionSupport.extractValue(insideCondition);
                    if (tagValue == null) {
                        return null;
                    }
                    if ("withLocalName".equals(insideCondition.getDebugMethodName())) {
                        result.setTagName(tagValue);
                        continue;
                    }
                    if (!"withNamespace".equals(insideCondition.getDebugMethodName())) continue;
                    result.setTagNamespace(tagValue);
                }
                continue;
            }
            return null;
        }
        result.generatePlaces();
        return result;
    }

    @Nullable
    private static String extractValue(PatternCondition<?> condition) {
        if (!(condition instanceof PatternConditionPlus)) {
            return null;
        }
        ElementPattern valuePattern = ((PatternConditionPlus)condition).getValuePattern();
        ElementPatternCondition rootCondition = valuePattern.getCondition();
        if (!String.class.equals((Object)rootCondition.getInitialCondition().getAcceptedClass())) {
            return null;
        }
        if (rootCondition.getConditions().size() != 1) {
            return null;
        }
        PatternCondition valueCondition = (PatternCondition)rootCondition.getConditions().get(0);
        if (!(valueCondition instanceof ValuePatternCondition)) {
            return null;
        }
        Collection values = ((ValuePatternCondition)valueCondition).getValues();
        if (values.size() == 1) {
            Object value = values.iterator().next();
            return value instanceof String ? (String)value : null;
        }
        if (!values.isEmpty()) {
            for (Object value : values) {
                if (value instanceof String) continue;
                return null;
            }
            return StringUtil.join((Collection)values, (String)"|");
        }
        return null;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        String place = StringUtil.notNullize((String)element.getChildText("place"), (String)"");
        if (place.startsWith("xmlAttribute")) {
            return new XmlAttributeInjection();
        }
        if (place.startsWith("xmlTag")) {
            return new XmlTagInjection();
        }
        return new BaseInjection(XML_SUPPORT_ID);
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[0];
    }

    private static boolean doInjectInXmlText(XmlText host, String languageId) {
        XmlTag tag = host.getParentTag();
        if (tag != null) {
            XmlTagInjection injection = new XmlTagInjection();
            injection.setInjectedLanguageId(languageId);
            injection.setTagName(tag.getLocalName());
            injection.setTagNamespace(tag.getNamespace());
            injection.generatePlaces();
            XmlLanguageInjectionSupport.doEditInjection(host.getProject(), injection);
            return true;
        }
        return false;
    }

    private static void doEditInjection(Project project, XmlTagInjection template) {
        Configuration configuration = InjectorUtils.getEditableInstance(project);
        AbstractTagInjection originalInjection = (AbstractTagInjection)configuration.findExistingInjection(template);
        XmlTagInjection newInjection = originalInjection == null ? template : new XmlTagInjection().copyFrom(originalInjection);
        configuration.replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
    }

    private static boolean doInjectInAttributeValue(XmlAttributeValue host, String languageId) {
        XmlTag tag;
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class, (boolean)true);
        XmlTag xmlTag = tag = attribute == null ? null : attribute.getParent();
        if (tag != null) {
            XmlAttributeInjection injection = new XmlAttributeInjection();
            injection.setInjectedLanguageId(languageId);
            injection.setAttributeName(attribute.getLocalName());
            injection.setAttributeNamespace(attribute.getNamespace());
            injection.setTagName(tag.getLocalName());
            injection.setTagNamespace(tag.getNamespace());
            injection.generatePlaces();
            XmlLanguageInjectionSupport.doEditInjection(host.getProject(), injection);
            return true;
        }
        return false;
    }

    private static void doEditInjection(Project project, XmlAttributeInjection template) {
        Configuration configuration = InjectorUtils.getEditableInstance(project);
        BaseInjection originalInjection = configuration.findExistingInjection(template);
        BaseInjection newInjection = originalInjection == null ? template : originalInjection.copy();
        configuration.replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
    }

    private static ArrayList<BaseInjection> collectInjections(PsiElement host, Configuration configuration) {
        ArrayList<BaseInjection> result = new ArrayList<BaseInjection>();
        XmlTag element = host instanceof XmlText ? ((XmlText)host).getParentTag() : (host instanceof XmlAttributeValue ? host.getParent() : host);
        for (BaseInjection injection : configuration.getInjections(XML_SUPPORT_ID)) {
            if (!injection.acceptsPsiElement((PsiElement)element)) continue;
            result.add(injection);
        }
        return result;
    }

    @Override
    public AnAction[] createAddActions(final Project project, final Consumer<BaseInjection> consumer) {
        return new AnAction[]{new AnAction("XML Tag Injection", null, PlatformIcons.XML_TAG_ICON){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection newInjection = XmlLanguageInjectionSupport.showInjectionUI(project, new XmlTagInjection());
                if (newInjection != null) {
                    consumer.consume((Object)newInjection);
                }
            }
        }, new AnAction("XML Attribute Injection", null, PlatformIcons.ANNOTATION_TYPE_ICON){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection injection = XmlLanguageInjectionSupport.showInjectionUI(project, new XmlAttributeInjection());
                if (injection != null) {
                    consumer.consume((Object)injection);
                }
            }
        }};
    }

    @Override
    public AnAction createEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection originalInjection = (BaseInjection)producer.create();
                BaseInjection injection = XmlLanguageInjectionSupport.createFrom(originalInjection);
                if (injection != null) {
                    BaseInjection newInjection = XmlLanguageInjectionSupport.showInjectionUI(project, injection);
                    if (newInjection != null) {
                        originalInjection.copyFrom(newInjection);
                    }
                } else {
                    AbstractLanguageInjectionSupport.createDefaultEditAction(project, (Factory<BaseInjection>)producer).actionPerformed(null);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjectionSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjectionSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

