/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MarginOptionsUtil;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSoftMarginsPresentation;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.valueEditors.CommaSeparatedIntegersValueEditor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappingAndBracesPanel
extends OptionTableWithPreviewPanel {
    private MultiMap<String, String> myGroupToFields = new MultiMap();
    private Map<String, SettingsGroup> myFieldNameToGroup;
    private final CommaSeparatedIntegersField mySoftMarginsEditor = new CommaSeparatedIntegersField(null, 0, 1000, "Optional");
    private final JComboBox<String> myWrapOnTypingCombo = new ComboBox((Object[])WRAP_ON_TYPING_OPTIONS);

    public WrappingAndBracesPanel(CodeStyleSettings settings) {
        super(settings);
        MarginOptionsUtil.customizeWrapOnTypingCombo(this.myWrapOnTypingCombo, settings);
        this.init();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.mySoftMarginsEditor);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, this.myWrapOnTypingCombo);
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS;
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        if (fieldName == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(0);
        }
        if (title == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(1);
        }
        super.addOption(fieldName, title, groupName);
        if (groupName != null) {
            this.myGroupToFields.putValue((Object)groupName, (Object)fieldName);
        }
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, @NotNull String[] options, @NotNull int[] values) {
        if (fieldName == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(2);
        }
        if (title == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(3);
        }
        if (options == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(4);
        }
        if (values == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(5);
        }
        super.addOption(fieldName, title, groupName, options, values);
        if (groupName == null) {
            this.myGroupToFields.putValue((Object)title, (Object)fieldName);
        }
    }

    @Override
    protected void initTables() {
        for (Map.Entry entry : CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType()).entrySet()) {
            CodeStyleSettingPresentation.SettingsGroup group = (CodeStyleSettingPresentation.SettingsGroup)entry.getKey();
            for (CodeStyleSettingPresentation setting : (List)entry.getValue()) {
                String fieldName = setting.getFieldName();
                String uiName = setting.getUiName();
                if (setting instanceof CodeStyleBoundedIntegerSettingPresentation) {
                    CodeStyleBoundedIntegerSettingPresentation intSetting = (CodeStyleBoundedIntegerSettingPresentation)setting;
                    int defaultValue = intSetting.getDefaultValue();
                    this.addOption(fieldName, uiName, group.name, intSetting.getLowerBound(), intSetting.getUpperBound(), defaultValue, this.getDefaultIntValueRenderer(fieldName));
                    continue;
                }
                if (setting instanceof CodeStyleSelectSettingPresentation) {
                    CodeStyleSelectSettingPresentation selectSetting = (CodeStyleSelectSettingPresentation)setting;
                    this.addOption(fieldName, uiName, group.name, selectSetting.getOptions(), selectSetting.getValues());
                    continue;
                }
                if (setting instanceof CodeStyleSoftMarginsPresentation) {
                    this.addSoftMarginsOption(fieldName, uiName, group.name);
                    this.showOption(fieldName);
                    continue;
                }
                this.addOption(fieldName, uiName, group.name);
            }
        }
    }

    private Function<Integer, String> getDefaultIntValueRenderer(@NotNull String fieldName) {
        if (fieldName == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(6);
        }
        if ("RIGHT_MARGIN".equals(fieldName)) {
            return integer -> MarginOptionsUtil.getDefaultRightMarginText(this.getSettings());
        }
        return integer -> ApplicationBundle.message((String)"integer.field.value.default", (Object[])new Object[0]);
    }

    protected SettingsGroup getAssociatedSettingsGroup(String fieldName) {
        if (this.myFieldNameToGroup == null) {
            this.myFieldNameToGroup = ContainerUtil.newHashMap();
            Set groups = this.myGroupToFields.keySet();
            for (String group : groups) {
                Collection fields = this.myGroupToFields.get((Object)group);
                SettingsGroup settingsGroup = new SettingsGroup(group, fields);
                for (String field : fields) {
                    this.myFieldNameToGroup.put(field, settingsGroup);
                }
            }
        }
        return this.myFieldNameToGroup.get(fieldName);
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"wrapping.and.braces", (Object[])new Object[0]);
    }

    private void addSoftMarginsOption(@NotNull String optionName, @NotNull String title, @Nullable String groupName) {
        Language language;
        if (optionName == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(7);
        }
        if (title == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(8);
        }
        if ((language = this.getDefaultLanguage()) != null) {
            this.addCustomOption(new SoftMarginsOption(language, optionName, title, groupName));
        }
    }

    private static List<Integer> castToIntList(@Nullable Object value) {
        if (value instanceof List && ((List)value).size() > 0 && ((List)value).get(0) instanceof Integer) {
            return (List)value;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected JComponent getCustomValueRenderer(@NotNull String optionName, @NotNull Object value) {
        if (optionName == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(9);
        }
        if (value == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(10);
        }
        if ("SoftMargins".equals(optionName)) {
            JLabel softMarginsLabel = new JLabel(this.getSoftMarginsString(WrappingAndBracesPanel.castToIntList(value)));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)softMarginsLabel);
            return softMarginsLabel;
        }
        if ("WRAP_ON_TYPING".equals(optionName) && value.equals(ApplicationBundle.message((String)"wrapping.wrap.on.typing.default", (Object[])new Object[0]))) {
            JLabel wrapLabel = new JLabel(MarginOptionsUtil.getDefaultWrapOnTypingText(this.getSettings()));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)wrapLabel);
            return wrapLabel;
        }
        return super.getCustomValueRenderer(optionName, value);
    }

    @NotNull
    private String getSoftMarginsString(@NotNull List<Integer> intList) {
        if (intList == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(11);
        }
        if (intList.size() > 0) {
            String string = CommaSeparatedIntegersValueEditor.intListToString(intList);
            if (string == null) {
                WrappingAndBracesPanel.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = MarginOptionsUtil.getDefaultVisualGuidesText(this.getSettings());
        if (string == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @Nullable
    protected JComponent getCustomNodeEditor(@NotNull OptionTableWithPreviewPanel.MyTreeNode node) {
        String optionName;
        if (node == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(14);
        }
        if ("SoftMargins".equals(optionName = node.getKey().getOptionName())) {
            this.mySoftMarginsEditor.setValue(WrappingAndBracesPanel.castToIntList(node.getValue()));
            return this.mySoftMarginsEditor;
        }
        if ("WRAP_ON_TYPING".equals(optionName)) {
            Object value = node.getValue();
            if (value instanceof String) {
                for (int i = 0; i < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS.length; ++i) {
                    if (!CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS.equals(value)) continue;
                    this.myWrapOnTypingCombo.setSelectedIndex(i);
                    break;
                }
            }
            return this.myWrapOnTypingCombo;
        }
        return super.getCustomNodeEditor(node);
    }

    @Override
    @Nullable
    protected Object getCustomNodeEditorValue(@NotNull JComponent customEditor) {
        if (customEditor == null) {
            WrappingAndBracesPanel.$$$reportNull$$$0(15);
        }
        if (customEditor instanceof CommaSeparatedIntegersField) {
            return ((CommaSeparatedIntegersField)customEditor).getValue();
        }
        if (customEditor == this.myWrapOnTypingCombo) {
            int i = this.myWrapOnTypingCombo.getSelectedIndex();
            return i >= 0 ? CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS[i] : null;
        }
        return super.getCustomNodeEditorValue(customEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intList";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/WrappingAndBracesPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/WrappingAndBracesPanel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftMarginsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultIntValueRenderer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSoftMarginsOption";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomValueRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSoftMarginsString";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCustomNodeEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCustomNodeEditorValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SoftMarginsOption
    extends OptionTableWithPreviewPanel.Option {
        private Language myLanguage;

        protected SoftMarginsOption(@NotNull Language language, @NotNull String optionName, @NotNull String title, @Nullable String groupName) {
            if (language == null) {
                SoftMarginsOption.$$$reportNull$$$0(0);
            }
            if (optionName == null) {
                SoftMarginsOption.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SoftMarginsOption.$$$reportNull$$$0(2);
            }
            super(optionName, title, groupName, null, null);
            this.myLanguage = language;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
            return langSettings.getSoftMargins();
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            settings.setSoftMargins(this.myLanguage, WrappingAndBracesPanel.castToIntList(value));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "language";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "optionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/WrappingAndBracesPanel$SoftMarginsOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class SettingsGroup {
        public final String title;
        public final Collection<String> commonCodeStyleSettingFieldNames;

        public SettingsGroup(@NotNull String title, @NotNull Collection<String> commonCodeStyleSettingFieldNames) {
            if (title == null) {
                SettingsGroup.$$$reportNull$$$0(0);
            }
            if (commonCodeStyleSettingFieldNames == null) {
                SettingsGroup.$$$reportNull$$$0(1);
            }
            this.title = title;
            this.commonCodeStyleSettingFieldNames = commonCodeStyleSettingFieldNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commonCodeStyleSettingFieldNames";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/codeStyle/WrappingAndBracesPanel$SettingsGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

