/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.featureStatistics.ProductivityFeaturesRegistry");
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myAdditionalFeaturesLoaded = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
    }

    private void reloadFromXml() {
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        try {
            this.readFromXml("file:///ProductivityFeaturesRegistry.xml");
        }
        catch (FileNotFoundException e) {
            if (!testMode) {
                LOG.error((Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        try {
            this.readFromXml("file:///IdeSpecificFeatures.xml");
        }
        catch (FileNotFoundException e) {
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private void readFromXml(String path) throws JDOMException, IOException {
        Document document = JDOMUtil.loadResourceDocument((URL)new URL(path));
        Element root = document.getRootElement();
        this.readGroups(root);
        this.readFilters(root);
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])ApplicationManager.getApplication().getComponents(ProductivityFeaturesProvider.class));
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])Extensions.getExtensions((ExtensionPointName)ProductivityFeaturesProvider.EP_NAME));
        this.myAdditionalFeaturesLoaded = true;
    }

    private void loadFeaturesFromProviders(ProductivityFeaturesProvider[] providers) {
        for (ProductivityFeaturesProvider provider : providers) {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptors;
            for (GroupDescriptor[] xmlUrl : provider.getXmlFilesUrls()) {
                try {
                    this.readFromXml((String)xmlUrl);
                }
                catch (Exception e) {
                    LOG.error("Error while reading " + (String)xmlUrl + " from " + provider + ": " + e.getMessage());
                }
            }
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptors = provider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptors) {
                    FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                    if (featureLoadedStatistics != null) {
                        featureDescriptor.copyStatistics(featureLoadedStatistics);
                    }
                    this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
                }
            }
            if ((applicabilityFilters = provider.getApplicabilityFilters()) == null) continue;
            for (ApplicabilityFilter applicabilityFilter : applicabilityFilters) {
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)applicabilityFilter.getPrefix(), (Object)applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element) {
        List filters = element.getChildren(TAG_FILTER);
        for (Object filter1 : filters) {
            Element filterElement = (Element)filter1;
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureSatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter2 = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)filterElement.getAttributeValue(PREFIX_ATTR), (Object)filter2));
            }
            catch (Exception e) {
                LOG.error("Cannot instantiate filter " + className, (Throwable)e);
            }
        }
    }

    private void readGroups(Element element) {
        List groups = element.getChildren(TAG_GROUP);
        for (Object group : groups) {
            Element groupElement = (Element)group;
            this.readGroup(groupElement);
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId = groupDescriptor.getId();
        this.myGroups.put(groupId, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        List features = groupElement.getChildren(TAG_FEATURE);
        for (Object feature : features) {
            Element featureElement = (Element)feature;
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor);
            featureDescriptor.readExternal(featureElement);
            if (TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) continue;
            this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
        }
    }

    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        Set<String> set2 = this.myFeatures.keySet();
        if (set2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(0);
        }
        return set2;
    }

    public FeatureDescriptor getFeatureDescriptor(@NotNull String id) {
        if (id == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(1);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.getFeatureDescriptorEx(id);
    }

    public FeatureDescriptor getFeatureDescriptorEx(@NotNull String id) {
        if (id == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(2);
        }
        if (WELCOME.equals(id)) {
            return new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
        }
        return this.myFeatures.get(id);
    }

    public GroupDescriptor getGroupDescriptor(@NotNull String id) {
        if (id == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(3);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id);
    }

    @NotNull
    public ApplicabilityFilter[] getMatchingFilters(@NotNull String featureId) {
        if (featureId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(4);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        ArrayList<Object> filters = new ArrayList<Object>();
        for (Pair<String, ApplicabilityFilter> pair : this.myApplicabilityFilters) {
            if (!featureId.startsWith((String)pair.getFirst())) continue;
            filters.add(pair.getSecond());
        }
        ApplicabilityFilter[] applicabilityFilterArray = filters.toArray(new ApplicabilityFilter[filters.size()]);
        if (applicabilityFilterArray == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(5);
        }
        return applicabilityFilterArray;
    }

    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureIds";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptorEx";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

