/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.VcsDataWrapper;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

class StartUseVcsDialog
extends DialogWrapper {
    private final VcsDataWrapper myData;
    private VcsCombo myVcsCombo;
    private String mySelected;

    StartUseVcsDialog(VcsDataWrapper data) {
        super(data.getProject(), true);
        this.myData = data;
        this.setTitle(VcsBundle.message((String)"dialog.enable.version.control.integration.title", (Object[])new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVcsCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.select.vcs.label.text", (Object[])new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridx;
        gb.anchor = 12;
        this.myVcsCombo = new VcsCombo(this.prepareComboData());
        mainPanel.add((Component)this.myVcsCombo, gb);
        this.myVcsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUseVcsDialog.this.validateVcs();
            }
        });
        this.validateVcs();
        JLabel helpText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.hint.text", (Object[])new Object[0]));
        helpText.setUI((LabelUI)new MultiLineLabelUI());
        helpText.setForeground(UIUtil.getInactiveTextColor());
        gb.anchor = 18;
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 2;
        mainPanel.add((Component)helpText, gb);
        JPanel wrapper2 = new JPanel(new GridBagLayout());
        wrapper2.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return wrapper2;
    }

    private void validateVcs() {
        String selectedVcs = this.myVcsCombo.getSelectedItem();
        this.setOKActionEnabled(selectedVcs.length() > 0);
    }

    protected String getHelpId() {
        return "reference.version.control.enable.version.control.integration";
    }

    protected void doOKAction() {
        this.mySelected = this.myVcsCombo.getSelectedItem();
        super.doOKAction();
    }

    private Object[] prepareComboData() {
        Set<String> displayNames = this.myData.getVcses().keySet();
        ArrayList<String> keys = new ArrayList<String>(displayNames.size() + 1);
        keys.add("");
        keys.addAll(displayNames);
        Collections.sort(keys);
        return ArrayUtil.toObjectArray(keys);
    }

    String getVcs() {
        return this.myData.getVcses().get(this.mySelected);
    }

    private static class VcsCombo
    extends JComboBox {
        private VcsCombo(Object[] items) {
            super(items);
            this.setSelectedIndex(0);
            this.setEditable(false);
        }

        @Override
        public String getSelectedItem() {
            return (String)super.getSelectedItem();
        }
    }
}

