/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import javax.swing.Icon;

public class AddNewFavoritesListAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            AddNewFavoritesListAction.doAddNewFavoritesList(project);
        }
    }

    public static String doAddNewFavoritesList(final Project project) {
        final FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String name = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.input.new.favorites.list.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.add.new.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)AddNewFavoritesListAction.getUniqueName(project), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (favoritesManager.getAvailableFavoritesListNames().contains(inputString)) {
                    Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return inputString.length() > 0;
            }
        });
        if (name == null || name.length() == 0) {
            return null;
        }
        favoritesManager.createNewList(name);
        return name;
    }

    private static String getUniqueName(Project project) {
        List<String> names = FavoritesManager.getInstance(project).getAvailableFavoritesListNames();
        int i = 0;
        String newName;
        while (names.contains(newName = IdeBundle.message((String)"favorites.list.unnamed", (Object[])new Object[]{i > 0 ? Integer.valueOf(i) : ""}))) {
            ++i;
        }
        return newName;
    }
}

