/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarItem
extends SimpleColoredComponent
implements DataProvider,
Disposable {
    private final String myText;
    private final SimpleTextAttributes myAttributes;
    private final int myIndex;
    private final Icon myIcon;
    private final NavBarPanel myPanel;
    private final Object myObject;
    private final boolean isPopupElement;
    private final NavBarUI myUI;

    public NavBarItem(NavBarPanel panel2, Object object, int idx, Disposable parent) {
        this.myPanel = panel2;
        this.myUI = panel2.getNavBarUI();
        this.myObject = object;
        this.myIndex = idx;
        boolean bl = this.isPopupElement = idx == -1;
        if (object != null) {
            NavBarPresentation presentation = this.myPanel.getPresentation();
            this.myText = presentation.getPresentableText(object);
            Icon icon = presentation.getIcon(object);
            this.myIcon = icon != null ? icon : JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)5));
            this.myAttributes = presentation.getTextAttributes(object, false);
        } else {
            this.myText = "Sample";
            this.myIcon = PlatformIcons.DIRECTORY_CLOSED_ICON;
            this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        Disposer.register((Disposable)(parent == null ? panel2 : parent), (Disposable)this);
        this.setOpaque(false);
        this.setIpad(this.myUI.getElementIpad(this.isPopupElement));
        if (!this.isPopupElement) {
            this.setMyBorder(null);
            this.setBorder(null);
            this.setPaintFocusBorder(false);
        }
        this.update();
    }

    public NavBarItem(NavBarPanel panel2, Object object, Disposable parent) {
        this(panel2, object, -1, parent);
    }

    public Object getObject() {
        return this.myObject;
    }

    public SimpleTextAttributes getAttributes() {
        return this.myAttributes;
    }

    public String getText() {
        return this.myText;
    }

    public Font getFont() {
        return this.myUI == null ? super.getFont() : this.myUI.getElementFont(this);
    }

    void update() {
        this.clear();
        this.setIcon(this.myIcon);
        boolean focused = this.isFocusedOrPopupElement();
        boolean selected = this.isSelected();
        this.setFocusBorderAroundIcon(false);
        this.setBackground(this.myUI.getBackground(selected, focused));
        Color fg = this.myUI.getForeground(selected, focused, this.isInactive());
        if (fg == null) {
            fg = this.myAttributes.getFgColor();
        }
        Color bg = this.getBackground();
        this.append(this.myText, new SimpleTextAttributes(bg, fg, this.myAttributes.getWaveColor(), this.myAttributes.getStyle()));
    }

    public boolean isInactive() {
        NavBarModel model = this.myPanel.getModel();
        return model.getSelectedIndex() < this.myIndex && model.getSelectedIndex() != -1;
    }

    public boolean isPopupElement() {
        return this.isPopupElement;
    }

    protected void doPaint(Graphics2D g) {
        if (this.isPopupElement) {
            super.doPaint(g);
        } else {
            this.myUI.doPaintNavBarItem(g, this, this.myPanel);
        }
    }

    public int doPaintText(Graphics2D g, int offset) {
        return super.doPaintText(g, offset, false);
    }

    public boolean isLastElement() {
        return this.myIndex == this.myPanel.getModel().size() - 1;
    }

    public boolean isFirstElement() {
        return this.myIndex == 0;
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension offsets = this.myUI.getOffsets(this);
        Dimension dimension = new Dimension(size.width + offsets.width, size.height + offsets.height);
        if (dimension == null) {
            NavBarItem.$$$reportNull$$$0(0);
        }
        return dimension;
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (dimension == null) {
            NavBarItem.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    private boolean isFocusedOrPopupElement() {
        return this.isFocused() || this.isPopupElement;
    }

    public boolean isFocused() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focusOwner == this.myPanel && !this.myPanel.isNodePopupActive();
    }

    public boolean isSelected() {
        NavBarModel model = this.myPanel.getModel();
        return this.isPopupElement ? this.myPanel.isSelectedInPopup(this.myObject) : model.getSelectedIndex() == this.myIndex;
    }

    protected boolean shouldDrawBackground() {
        return this.isSelected() && this.isFocusedOrPopupElement();
    }

    protected boolean shouldDrawMacShadow() {
        return this.myUI.isDrawMacShadow(this.isSelected(), this.isFocused());
    }

    public boolean isIconOpaque() {
        return false;
    }

    public void dispose() {
    }

    public boolean isNextSelected() {
        return this.myIndex == this.myPanel.getModel().getSelectedIndex() - 1;
    }

    @Nullable
    public Object getData(String dataId) {
        return this.myPanel.getDataImpl(dataId, () -> JBIterable.of((Object)this.myObject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/navigationToolbar/NavBarItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

