/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeTreeViewPanel;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private ScopeTreeViewPanel myViewPanel;
    private final DependencyValidationManager myDependencyValidationManager;
    private final NamedScopeManager myNamedScopeManager;
    private final NamedScopesHolder.ScopeListener myScopeListener;

    public ScopeViewPane(@NotNull Project project, DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        if (project == null) {
            ScopeViewPane.$$$reportNull$$$0(0);
        }
        super(project);
        this.myDependencyValidationManager = dependencyValidationManager;
        this.myNamedScopeManager = namedScopeManager;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){
            final Alarm refreshProjectViewAlarm;
            {
                this.refreshProjectViewAlarm = new Alarm((Disposable)ScopeViewPane.this.myProject);
            }

            public void scopesChanged() {
                if (this.refreshProjectViewAlarm.isDisposed()) {
                    return;
                }
                this.refreshProjectViewAlarm.cancelAllRequests();
                this.refreshProjectViewAlarm.addRequest(() -> {
                    if (ScopeViewPane.this.myProject.isDisposed()) {
                        return;
                    }
                    String subId = ScopeViewPane.this.getSubId();
                    ProjectView projectView = ProjectView.getInstance(ScopeViewPane.this.myProject);
                    String id = projectView.getCurrentViewId();
                    projectView.removeProjectPane(ScopeViewPane.this);
                    projectView.addProjectPane(ScopeViewPane.this);
                    if (id != null) {
                        if (Comparing.strEqual((String)id, (String)ScopeViewPane.this.getId())) {
                            projectView.changeView(id, subId);
                        } else {
                            projectView.changeView(id);
                        }
                    }
                }, 10);
            }
        };
        this.myDependencyValidationManager.addScopeListener(this.myScopeListener);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Ide.LocalScope;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScopeViewPane.$$$reportNull$$$0(1);
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        if (this.myViewPanel == null) {
            this.myViewPanel = new ScopeTreeViewPanel(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myViewPanel);
            this.myViewPanel.initListeners();
            this.myTree = this.myViewPanel.getTree();
            CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ScopeViewPopupMenu", "ScopeViewPopup");
            this.enableDnD();
        }
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        return this.myViewPanel.getPanel();
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        this.myDependencyValidationManager.removeScopeListener(this.myScopeListener);
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        String[] stringArray = (String[])ContainerUtil.map2Array(this.getShownScopes(), String.class, scope -> scope.getName());
        if (stringArray == null) {
            ScopeViewPane.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public static Collection<NamedScope> getShownScopes(@NotNull Project project) {
        if (project == null) {
            ScopeViewPane.$$$reportNull$$$0(3);
        }
        Collection<NamedScope> collection = ScopeViewPane.getShownScopes(DependencyValidationManager.getInstance((Project)project), NamedScopeManager.getInstance((Project)project));
        if (collection == null) {
            ScopeViewPane.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private Collection<NamedScope> getShownScopes() {
        return ScopeViewPane.getShownScopes(this.myDependencyValidationManager, this.myNamedScopeManager);
    }

    @NotNull
    private static Collection<NamedScope> getShownScopes(DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        ArrayList list2 = ContainerUtil.newArrayList();
        for (NamedScope scope : ContainerUtil.concat((Object[][])new NamedScope[][]{dependencyValidationManager.getScopes(), namedScopeManager.getScopes()})) {
            if (scope instanceof NonProjectFilesScope || scope instanceof ScratchesNamedScope || scope == CustomScopesProviderEx.getAllScope()) continue;
            list2.add(scope);
        }
        ArrayList arrayList = list2;
        if (arrayList == null) {
            ScopeViewPane.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            ScopeViewPane.$$$reportNull$$$0(6);
        }
        String string = subId;
        if (string == null) {
            ScopeViewPane.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.add(ActionManager.getInstance().getAction("ScopeView.EditScopes"));
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject){

            @Override
            @NotNull
            protected String getId() {
                String string = ScopeViewPane.this.getId();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane$2", "getId"));
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)this.createFlattenModulesAction(() -> true)).setAsSecondary(true);
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        this.saveExpandedPaths();
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        this.restoreExpandedPaths();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(8);
        }
        return actionCallback;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        String name;
        PsiDirectory psiFile;
        if (file2 == null) {
            return;
        }
        Object object = psiFile = file2.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(file2) : PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return;
        }
        if (!(element instanceof PsiElement)) {
            return;
        }
        ArrayList allScopes = ContainerUtil.newArrayList(this.getShownScopes());
        for (NamedScope scope : allScopes) {
            name = scope.getName();
            if (!name.equals(this.getSubId())) continue;
            allScopes.remove(scope);
            allScopes.add(0, scope);
            break;
        }
        for (NamedScope scope : allScopes) {
            name = scope.getName();
            PackageSet packageSet = scope.getValue();
            if (packageSet == null || !this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myNamedScopeManager, requestFocus) && !this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myDependencyValidationManager, requestFocus)) continue;
            break;
        }
    }

    private boolean changeView(PackageSet packageSet, PsiElement element, PsiFileSystemItem psiFileSystemItem, String name, NamedScopesHolder holder, boolean requestFocus) {
        if (packageSet instanceof PackageSetBase && ((PackageSetBase)packageSet).contains(psiFileSystemItem.getVirtualFile(), this.myProject, holder) || psiFileSystemItem instanceof PsiFile && packageSet.contains((PsiFile)psiFileSystemItem, holder)) {
            if (!name.equals(this.getSubId())) {
                if (!requestFocus) {
                    return true;
                }
                ProjectView.getInstance(this.myProject).changeView(this.getId(), name);
            }
            this.myViewPanel.selectNode(element, psiFileSystemItem, requestFocus);
            return true;
        }
        return false;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    @Override
    public void installComparator() {
        this.myViewPanel.setSortByType();
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        if (node instanceof PackageDependenciesNode) {
            return ((PackageDependenciesNode)node).getPsiElement();
        }
        return super.exhumeElementFromNode(node);
    }

    @Override
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        return this.myViewPanel == null ? null : this.myViewPanel.getData(dataId);
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        ActionCallback callback;
        if (requestor == null) {
            ScopeViewPane.$$$reportNull$$$0(9);
        }
        ActionCallback actionCallback = (callback = this.myViewPanel.getActionCallback()) == null ? ActionCallback.DONE : callback;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShownScopes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getShownScopes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

