/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(0);
        }
        if (e == null) {
            ScratchFileActions.$$$reportNull$$$0(1);
        }
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file2 == null && editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        ScratchFileCreationHelper.Context context = new ScratchFileCreationHelper.Context();
        context.text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
        if (!context.text.isEmpty()) {
            context.language = ScratchFileActions.getLanguageFromCaret(project, editor, file2);
            ScratchFileActions.checkLanguageAndTryToFixText(project, context, e.getDataContext());
        } else {
            context.text = StringUtil.notNullize((String)((String)e.getData(PlatformDataKeys.PREDEFINED_TEXT)));
        }
        ScratchFileCreationHelper.Context context2 = context;
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(2);
        }
        return context2;
    }

    static void doCreateNewScratch(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ScratchFileActions.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        Language language = (Language)ObjectUtils.notNull((Object)context.language);
        if (context.fileExtension == null) {
            LanguageFileType fileType = language.getAssociatedFileType();
            context.fileExtension = fileType == null ? "" : fileType.getDefaultExtension();
        }
        ((ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(language)).beforeCreate(project, context);
        String fileName = PathUtil.makeFileName((String)((String)ObjectUtils.notNull((Object)context.filePrefix, (Object)"scratch") + (context.fileCounter != null ? (Serializable)context.fileCounter.create() : "")), (String)context.fileExtension);
        VirtualFile f = ScratchRootType.getInstance().createScratchFile(project, fileName, language, context.text, context.createOption);
        if (f != null) {
            new OpenFileDescriptor(project, f, context.caretOffset).navigate(true);
        }
    }

    private static void checkLanguageAndTryToFixText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ScratchFileActions.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(7);
        }
        if (context.language == null) {
            return;
        }
        ScratchFileCreationHelper handler2 = (ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context.language);
        if (handler2.prepareText(project, context, dataContext)) {
            return;
        }
        PsiFile psiFile = ScratchFileCreationHelper.parseHeader(project, context.language, context.text);
        PsiErrorElement firstError = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)psiFile).traverse().filter(PsiErrorElement.class).first();
        if (firstError != null && firstError.getParent() == psiFile) {
            context.language = null;
        }
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project == null) {
            ScratchFileActions.$$$reportNull$$$0(8);
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element != null ? element.getContainingFile() : psiFile;
        Language language = file2.getLanguage();
        if (language == StdLanguages.TEXT && file2.getFileType() instanceof InternalFileType) {
            return StdLanguages.XML;
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNewScratch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkLanguageAndTryToFixText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            Project project = e.getProject();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project == null || files.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project);
            if (!files.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set languages = (Set)files.filter(isScratch).transform(this.fileLanguage(project)).filter(Conditions.notNull()).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
            String langName = languages.size() == 1 ? ((Language)languages.iterator().next()).getDisplayName() : languages.size() + " different";
            e.getPresentation().setText(String.format("Change %s (%s)...", this.getLanguageTerm(), langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        protected String getLanguageTerm() {
            if ("Language" == null) {
                LanguageAction.$$$reportNull$$$0(0);
            }
            return "Language";
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(this.fileFilter(project));
            if (project == null || files.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project, (JBIterable<VirtualFile>)files);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(Project project) {
            Condition condition = file2 -> ScratchRootType.getInstance().containsFile((VirtualFile)file2);
            if (condition == null) {
                LanguageAction.$$$reportNull$$$0(1);
            }
            return condition;
        }

        @NotNull
        protected Function<VirtualFile, Language> fileLanguage(final Project project) {
            Function<VirtualFile, Language> function = new Function<VirtualFile, Language>(){
                ScratchFileService fileService = ScratchFileService.getInstance();

                public Language fun(VirtualFile file2) {
                    Language lang = (Language)this.fileService.getScratchesMapping().getMapping(file2);
                    return lang != null ? lang : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
                }
            };
            if (function == null) {
                LanguageAction.$$$reportNull$$$0(2);
            }
            return function;
        }

        protected void actionPerformedImpl(AnActionEvent e, Project project, JBIterable<VirtualFile> files) {
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings mapping = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project, files, (PerFileMappings<Language>)mapping).showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/scratch/ScratchFileActions$LanguageAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageTerm";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(0);
            }
            boolean enabled = e.getProject() != null && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(project, e);
            context.filePrefix = "buffer";
            context.createOption = ScratchFileService.Option.create_if_missing;
            context.fileCounter = () -> ScratchFileActions.nextBufferIndex();
            if (context.language == null) {
                context.language = StdLanguages.TEXT;
            }
            ScratchFileActions.doCreateNewScratch(project, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        private static final Icon ICON = LayeredIcon.create((Icon)AllIcons.FileTypes.Text, (Icon)AllIcons.Actions.Scratch);
        private static final String ACTION_ID = "NewScratchFile";
        private static final String SMALLER_IDE_CONTAINER_GROUP = "PlatformOpenProjectGroup";
        private final String myActionText;

        public NewFileAction() {
            this.getTemplatePresentation().setIcon(ICON);
            this.myActionText = (this.isIdeWithoutNewSubmenu() ? "New " : "") + ActionsBundle.actionText((String)ACTION_ID);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(0);
            }
            this.getTemplatePresentation().setText(this.myActionText);
            String place = e.getPlace();
            boolean enabled = e.getProject() != null && (ActionPlaces.isMainMenuOrActionSearch((String)place) || ActionPlaces.isPopupPlace((String)place));
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e, presentation);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(project, e);
            Consumer consumer = l -> {
                context.language = l;
                ((ScratchFileCreationHelper)ScratchFileCreationHelper.EXTENSION.forLanguage(context.language)).prepareText(project, context, DataContext.EMPTY_CONTEXT);
                ScratchFileActions.doCreateNewScratch(project, context);
            };
            if (context.language != null) {
                consumer.consume((Object)context.language);
            } else {
                LRUPopupBuilder.forFileLanguages(project, null, (Consumer<Language>)consumer).showCenteredInCurrentWindow(project);
            }
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e, @NotNull Presentation presentation) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(2);
            }
            if (presentation == null) {
                NewFileAction.$$$reportNull$$$0(3);
            }
            presentation.setText(this.myActionText);
            presentation.setIcon(ICON);
            if ("MainMenu".equals(e.getPlace()) && this.isIdeWithoutNewSubmenu()) {
                presentation.setIcon(null);
            }
        }

        private boolean isIdeWithoutNewSubmenu() {
            AnAction group = ActionManager.getInstance().getActionOrStub(SMALLER_IDE_CONTAINER_GROUP);
            return group instanceof DefaultActionGroup && ContainerUtil.find((Object[])((DefaultActionGroup)group).getChildActionsOrStubs(), action -> action == this || action instanceof ActionStub && ((ActionStub)action).getId().equals(ACTION_ID)) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentationTextAndIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

