/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return (Registry.is((String)"ide.scratch.in.project.view") || PlatformUtils.isDatabaseIDE()) && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(Project project) {
        super(project);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    @Override
    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        ProjectTreeBuilder builder = new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            @Override
            protected ProjectViewPsiTreeChangeListener createPsiTreeChangeListener(Project project) {
                return new ProjectTreeBuilder.ProjectTreeBuilderPsiListener(project){

                    @Override
                    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                        VirtualFile virtualFile;
                        VirtualFile virtualFile2 = virtualFile = parent instanceof PsiFileSystemItem ? ((PsiFileSystemItem)parent).getVirtualFile() : null;
                        if (virtualFile != null && virtualFile.isValid() && ScratchFileService.getInstance().getRootType(virtualFile) != null) {
                            this.queueUpdateFrom(parent, true);
                        }
                    }
                };
            }
        };
        for (RootType rootId : RootType.getAllRootIds()) {
            if (rootId.isHidden()) continue;
            rootId.registerTreeUpdater(this.myProject, (Disposable)builder, () -> ((ProjectTreeBuilder)builder).queueUpdate());
        }
        ProjectTreeBuilder projectTreeBuilder = builder;
        if (projectTreeBuilder == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(1);
        }
        return projectTreeBuilder;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                if (!vFile.isInLocalFileSystem()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getPSIElement(@Nullable Object element) {
        return element instanceof RootType ? ScratchProjectViewPane.getDirectory(this.myProject, (RootType)element) : super.getPSIElement(element);
    }

    @Nullable
    static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootId) {
        VirtualFile virtualFile;
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(2);
        }
        if (rootId == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(3);
        }
        return (virtualFile = ScratchProjectViewPane.getVirtualFile(rootId)) == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Nullable
    static VirtualFile getVirtualFile(@NotNull RootType rootId) {
        if (rootId == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(4);
        }
        String path = ScratchFileService.getInstance().getRootPath(rootId);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(6);
        }
        MyProjectNode myProjectNode = new MyProjectNode(project, settings);
        if (myProjectNode == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(7);
        }
        return myProjectNode;
    }

    private static void customizePresentation(@NotNull BasePsiNode node, @NotNull PresentationData data) {
        Icon icon;
        MyRootNode rootNode;
        if (node == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(8);
        }
        if (data == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(9);
        }
        VirtualFile file2 = (VirtualFile)ObjectUtils.notNull((Object)node.getVirtualFile());
        Project project = (Project)ObjectUtils.notNull((Object)node.getProject());
        AbstractTreeNode parent = node.getParent();
        MyRootNode myRootNode = parent instanceof MyRootNode ? (MyRootNode)parent : (rootNode = parent instanceof PsiDirectoryNode ? (MyRootNode)((PsiDirectoryNode)parent).getFilter() : null);
        if (rootNode == null) {
            return;
        }
        RootType rootType = rootNode.getRootType();
        String name = rootType.substituteName(project, file2);
        if (name != null) {
            data.setPresentableText(name);
        }
        if ((icon = rootType.substituteIcon(project, file2)) != null) {
            data.setIcon(icon);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project, RootType type, ViewSettings settings) {
            super(project, (Object)type, settings);
        }

        @NotNull
        public RootType getRootType() {
            RootType rootType = (RootType)ObjectUtils.notNull((Object)this.getValue());
            if (rootType == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            return rootType;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return ScratchFileService.getInstance().getRootType(file2) == this.getValue();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchProjectViewPane.getVirtualFile(this.getRootType());
        }

        @NotNull
        public Collection<VirtualFile> getRoots() {
            VirtualFile root = this.getVirtualFile();
            Set<VirtualFile> set2 = root == null ? EMPTY_ROOTS : Collections.singleton(root);
            if (set2 == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return set2;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            Collection<AbstractTreeNode> collection = MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return collection;
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project = (Project)ObjectUtils.notNull((Object)this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            if (item == null) {
                MyRootNode.$$$reportNull$$$0(4);
            }
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode> getDirectoryChildrenImpl(final @NotNull Project project, @Nullable PsiDirectory directory2, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter2) {
            if (project == null) {
                MyRootNode.$$$reportNull$$$0(5);
            }
            if (settings == null) {
                MyRootNode.$$$reportNull$$$0(6);
            }
            if (filter2 == null) {
                MyRootNode.$$$reportNull$$$0(7);
            }
            final ArrayList result2 = ContainerUtil.newArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filter2.shouldShow(element)) {
                        if (element instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project, (PsiDirectory)element, settings, filter2){

                                @Override
                                public Collection<AbstractTreeNode> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }

                                @Override
                                protected void updateImpl(PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        } else if (element instanceof PsiFile) {
                            result2.add(new PsiFileNode(project, (PsiFile)element, settings){

                                @Override
                                public Comparable getTypeSortKey() {
                                    PsiFile value = (PsiFile)this.getValue();
                                    Language language = value == null ? null : value.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }

                                @Override
                                protected void updateImpl(PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1", "execute"));
                }
            };
            Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> MyRootNode.lambda$getDirectoryChildrenImpl$0(directory2, (PsiElementProcessor)processor2, result2));
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(8);
            }
            return collection;
        }

        private static /* synthetic */ List lambda$getDirectoryChildrenImpl$0(@Nullable PsiDirectory directory2, PsiElementProcessor processor2, List result2) {
            if (directory2 == null || !directory2.isValid()) {
                return Collections.emptyList();
            }
            directory2.processChildren(processor2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootType";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)"Scratches and Consoles", settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list2 = ContainerUtil.newArrayList();
            for (RootType rootId : RootType.getAllRootIds()) {
                MyRootNode e;
                if (rootId.isHidden() || (e = new MyRootNode(this.getProject(), rootId, this.getSettings())).isEmpty()) continue;
                list2.add(e);
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.General.ProjectTab);
        }

        public boolean canRepresent(Object element) {
            VirtualFile virtualFile;
            PsiElement item = element instanceof PsiElement ? (PsiElement)element : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Comparing.equal((String)virtualFile.getPath(), (String)FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(Project project) {
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
            return ScratchProjectViewPane.createRootNode(project, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }
}

