/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchStrategy;
import com.intellij.openapi.vcs.changes.patch.IndividualPiecesStrategy;
import com.intellij.openapi.vcs.changes.patch.OneBaseStrategy;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AutoMatchIterator {
    private final Project myProject;
    private final List<AutoMatchStrategy> myStrategies;

    public AutoMatchIterator(Project project) {
        this.myProject = project;
        VirtualFile baseDir = this.myProject.getBaseDir();
        this.myStrategies = new LinkedList<AutoMatchStrategy>();
        this.myStrategies.add(new OneBaseStrategy(baseDir));
        this.myStrategies.add(new IndividualPiecesStrategy(baseDir));
        this.myStrategies.add(new DefaultPatchStrategy(baseDir));
    }

    public List<TextFilePatchInProgress> execute(List<TextFilePatch> list2) {
        LinkedList<TextFilePatch> creations = new LinkedList<TextFilePatch>();
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        for (TextFilePatch patch : list2) {
            if (patch.isNewFile() || patch.getBeforeName() == null) {
                creations.add(patch);
                continue;
            }
            String fileName = patch.getBeforeFileName();
            Collection files = (Collection)ReadAction.compute(() -> directoryDetector.findFiles(fileName));
            for (AutoMatchStrategy strategy : this.myStrategies) {
                strategy.acceptPatch(patch, files);
            }
        }
        for (AutoMatchStrategy strategy : this.myStrategies) {
            strategy.beforeCreations();
        }
        for (TextFilePatch creation : creations) {
            for (AutoMatchStrategy strategy : this.myStrategies) {
                strategy.processCreation(creation);
            }
        }
        for (AutoMatchStrategy strategy : this.myStrategies) {
            if (!strategy.succeeded()) continue;
            return strategy.getResult();
        }
        return this.myStrategies.get(this.myStrategies.size() - 1).getResult();
    }
}

