/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeData>> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull String logId, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (fatalErrorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        super(logId, PATHS, VcsLogPersistentIndex.getVersion(), new PathsIndexer(VcsLogPathsIndex.createPathsEnumerator(logId), roots), new ChangeDataListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (fatalErrorHandler == null) {
                VcsLogPathsIndex.$$$reportNull$$$0(24);
            }
            fatalErrorHandler.consume(this, (Throwable)e);
        }));
    }

    @NotNull
    private static PersistentEnumeratorBase<String> createPathsEnumerator(@NotNull String logId) throws IOException {
        if (logId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        File storageFile = PersistentUtil.getStorageFile("index", INDEX_PATHS_IDS, logId, VcsLogPersistentIndex.getVersion());
        PersistentBTreeEnumerator persistentBTreeEnumerator = new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)(SystemInfo.isFileSystemCaseSensitive ? EnumeratorStringDescriptor.INSTANCE : new ToLowerCaseStringDescriptor()), Page.PAGE_SIZE, null, VcsLogPersistentIndex.getVersion());
        if (persistentBTreeEnumerator == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(5);
        }
        return persistentBTreeEnumerator;
    }

    @Nullable
    public String getPath(int pathId) {
        try {
            return (String)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @NotNull
    public TIntHashSet getCommitsForPaths(@NotNull Collection<FilePath> paths) throws IOException, StorageException {
        if (paths == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(6);
        }
        Set<Integer> allPathIds = this.getPathIds(paths);
        TIntHashSet result2 = new TIntHashSet();
        Set<Integer> renames = allPathIds;
        while (!renames.isEmpty()) {
            renames = this.addCommitsAndGetRenames(renames, allPathIds, result2);
            allPathIds.addAll(renames);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        return tIntHashSet;
    }

    @NotNull
    private Set<Integer> getPathIds(@NotNull Collection<FilePath> paths) throws IOException {
        if (paths == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        HashSet allPathIds = ContainerUtil.newHashSet();
        for (FilePath path : paths) {
            allPathIds.add(this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath()));
        }
        HashSet hashSet = allPathIds;
        if (hashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) throws IOException, StorageException {
        if (path == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(10);
        }
        int startId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path.getPath());
        HashSet startIds = ContainerUtil.newHashSet();
        startIds.add(startId);
        HashSet allIds = ContainerUtil.newHashSet((Iterable)startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        HashSet resultIds = ContainerUtil.newHashSet();
        block0: while (!startIds.isEmpty()) {
            Iterator iterator = startIds.iterator();
            while (iterator.hasNext()) {
                int currentPathId = (Integer)iterator.next();
                boolean foundCommit = !this.iterateCommitIdsAndValues(currentPathId, (T changesList, Integer commitId) -> {
                    Set<Integer> otherNames = VcsLogPathsIndex.getOtherNames(changesList);
                    if (commitId == commit) {
                        resultIds.add(currentPathId);
                        resultIds.addAll(otherNames);
                        return false;
                    }
                    for (Integer otherPath : otherNames) {
                        if (allIds.contains(otherPath)) continue;
                        newIds.add(otherPath);
                    }
                    return true;
                });
                if (!foundCommit) continue;
                break block0;
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (Integer id : resultIds) {
            result2.add(VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(id.intValue()))));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    public void iterateCommits(@NotNull FilePath path, @NotNull ObjIntConsumer<Pair<FilePath, List<ChangeData>>> consumer) throws IOException, StorageException {
        if (path == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(13);
        }
        HashSet startIds = this.getPathIds(Collections.singleton(path));
        HashSet allIds = ContainerUtil.newHashSet(startIds);
        HashSet newIds = ContainerUtil.newHashSet();
        while (!startIds.isEmpty()) {
            for (int currentPathId : startIds) {
                FilePath currentPath = VcsUtil.getFilePath((String)((String)this.myPathsIndexer.myPathsEnumerator.valueOf(currentPathId)));
                this.iterateCommitIdsAndValues(currentPathId, (T changesList, int commitId) -> {
                    if (consumer == null) {
                        VcsLogPathsIndex.$$$reportNull$$$0(23);
                    }
                    Set<Integer> otherNames = VcsLogPathsIndex.getOtherNames(changesList);
                    for (int renamed : otherNames) {
                        if (allIds.contains(renamed)) continue;
                        newIds.add(renamed);
                    }
                    consumer.accept(Pair.create((Object)currentPath, (Object)changesList), commitId);
                });
            }
            startIds = ContainerUtil.newHashSet((Iterable)newIds);
            allIds.addAll(startIds);
            newIds.clear();
        }
    }

    @NotNull
    public Set<Integer> addCommitsAndGetRenames(@NotNull Set<Integer> newPathIds, @NotNull Set<Integer> allPathIds, @NotNull TIntHashSet commits) throws StorageException {
        if (newPathIds == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(14);
        }
        if (allPathIds == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(15);
        }
        if (commits == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(16);
        }
        HashSet renames = ContainerUtil.newHashSet();
        for (Integer key : newPathIds) {
            this.iterateCommitIdsAndValues((int)key, (T value, int commit) -> {
                if (commits == null) {
                    VcsLogPathsIndex.$$$reportNull$$$0(20);
                }
                if (allPathIds == null) {
                    VcsLogPathsIndex.$$$reportNull$$$0(21);
                }
                commits.add(commit);
                renames.addAll(ContainerUtil.filter(VcsLogPathsIndex.getOtherNames(value), r -> {
                    if (allPathIds == null) {
                        VcsLogPathsIndex.$$$reportNull$$$0(22);
                    }
                    return !allPathIds.contains(r);
                }));
            });
        }
        HashSet hashSet = renames;
        if (hashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private static Set<Integer> getOtherNames(@NotNull List<ChangeData> changesList) {
        if (changesList == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(18);
        }
        HashSet otherNames = ContainerUtil.newHashSet();
        for (ChangeData data : changesList) {
            if (data == null || data.otherPath == -1) continue;
            otherNames.add(data.otherPath);
        }
        HashSet hashSet = otherNames;
        if (hashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATHS;
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPathIds";
                break;
            }
            case 15: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPathIds";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathsEnumerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsForPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addCommitsAndGetRenames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPathsEnumerator";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsForPaths";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathIds";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCommitsAndGetRenames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOtherNames";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCommitsAndGetRenames$4";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateCommits$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToLowerCaseStringDescriptor
    implements KeyDescriptor<String> {
        private ToLowerCaseStringDescriptor() {
        }

        public int getHashCode(String value) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(value);
        }

        public boolean isEqual(String val1, String val2) {
            return CaseInsensitiveStringHashingStrategy.INSTANCE.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, String value) throws IOException {
            if (out == null) {
                ToLowerCaseStringDescriptor.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.toLowerCase());
        }

        public String read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ToLowerCaseStringDescriptor.$$$reportNull$$$0(1);
            }
            return IOUtil.readUTF((DataInput)in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ToLowerCaseStringDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        RENAMED_FROM(1),
        RENAMED_TO(2);

        public final byte id;

        private ChangeKind(byte id) {
            this.id = id;
        }

        public static ChangeKind getKind(byte id) {
            switch (id) {
                case 0: {
                    return MODIFIED;
                }
                case 1: {
                    return RENAMED_FROM;
                }
                case 2: {
                    return RENAMED_TO;
                }
            }
            throw new IllegalArgumentException("No change kind with id " + id);
        }
    }

    public static class ChangeData {
        @NotNull
        public final ChangeKind kind;
        public final int otherPath;

        public ChangeData(@NotNull ChangeKind kind, int otherPath) {
            if (kind == null) {
                ChangeData.$$$reportNull$$$0(0);
            }
            this.kind = kind;
            this.otherPath = otherPath;
        }

        public boolean isRename() {
            return this.kind.equals((Object)ChangeKind.RENAMED_FROM) || this.kind.equals((Object)ChangeKind.RENAMED_TO);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeData data = (ChangeData)o;
            return this.otherPath == data.otherPath && this.kind == data.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.otherPath});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeData", "<init>"));
        }
    }

    private static class ChangeDataListKeyDescriptor
    implements DataExternalizer<List<ChangeData>> {
        private ChangeDataListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeData> value) throws IOException {
            if (out == null) {
                ChangeDataListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeData data : value) {
                if (data == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                out.writeByte(data.kind.id);
                if (data.kind != ChangeKind.RENAMED_TO && data.kind != ChangeKind.RENAMED_FROM) continue;
                out.writeInt(data.otherPath);
            }
        }

        public List<ChangeData> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeDataListKeyDescriptor.$$$reportNull$$$0(1);
            }
            List value = ContainerUtil.newSmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                if (in.readBoolean()) {
                    ChangeKind kind = ChangeKind.getKind(in.readByte());
                    int otherPath = kind == ChangeKind.RENAMED_TO || kind == ChangeKind.RENAMED_FROM ? in.readInt() : -1;
                    value.add(new ChangeData(kind, otherPath));
                    continue;
                }
                value.add(null);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeDataListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, List<ChangeData>, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<String> myPathsEnumerator;
        @NotNull
        private final Set<String> myRoots;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull PersistentEnumeratorBase<String> enumerator, @NotNull Set<VirtualFile> roots) {
            if (enumerator == null) {
                PathsIndexer.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                PathsIndexer.$$$reportNull$$$0(1);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myPathsEnumerator = enumerator;
            this.myRoots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
            for (VirtualFile root : roots) {
                this.myRoots.add(root.getPath());
            }
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                PathsIndexer.$$$reportNull$$$0(2);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeData>> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                PathsIndexer.$$$reportNull$$$0(3);
            }
            THashMap result2 = new THashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            int parent = 0;
            while (parent < parentsCount) {
                Collection<Object> moves;
                Collection<Object> changedPaths;
                if (inputData instanceof VcsIndexableDetails) {
                    changedPaths = ((VcsIndexableDetails)inputData).getModifiedPaths(parent);
                    moves = ((VcsIndexableDetails)inputData).getRenamedPaths(parent);
                } else {
                    moves = ContainerUtil.newHashSet();
                    changedPaths = ContainerUtil.newHashSet();
                    for (Change change : inputData.getChanges()) {
                        if (change.getAfterRevision() != null) {
                            changedPaths.add(change.getAfterRevision().getFile().getPath());
                        }
                        if (change.getBeforeRevision() != null) {
                            changedPaths.add(change.getBeforeRevision().getFile().getPath());
                        }
                        if (!change.getType().equals((Object)Change.Type.MOVED)) continue;
                        moves.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
                    }
                }
                int finalParent = parent++;
                moves.forEach(move -> {
                    changedPaths.add(PathUtil.getParentPath((String)((String)move.first)));
                    changedPaths.add(PathUtil.getParentPath((String)((String)move.second)));
                });
                this.getParentPaths((Collection<String>)changedPaths).forEach(arg_0 -> this.lambda$map$1((Map)result2, finalParent, parentsCount, arg_0));
                moves.forEach(arg_0 -> this.lambda$map$2((Map)result2, finalParent, parentsCount, arg_0));
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                PathsIndexer.$$$reportNull$$$0(4);
            }
            return tHashMap;
        }

        private void addChangeToResult(@NotNull Map<Integer, List<ChangeData>> commitChangesMap, int parent, int parentsCount, @NotNull String afterPath, @Nullable String beforePath) throws IOException {
            if (commitChangesMap == null) {
                PathsIndexer.$$$reportNull$$$0(5);
            }
            if (afterPath == null) {
                PathsIndexer.$$$reportNull$$$0(6);
            }
            int afterId = this.myPathsEnumerator.enumerate((Object)afterPath);
            List<ChangeData> changeDataList = PathsIndexer.getOrCreateChangeDataListForPath(commitChangesMap, afterId, parentsCount);
            if (beforePath == null) {
                PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.MODIFIED, -1));
            } else {
                int beforeId = this.myPathsEnumerator.enumerate((Object)beforePath);
                if (beforeId == afterId && !SystemInfo.isFileSystemCaseSensitive) {
                    PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.MODIFIED, -1));
                } else {
                    PathsIndexer.addChange(changeDataList, parent, new ChangeData(ChangeKind.RENAMED_TO, beforeId));
                    List<ChangeData> beforeChangeDataList = PathsIndexer.getOrCreateChangeDataListForPath(commitChangesMap, beforeId, parentsCount);
                    PathsIndexer.addChange(beforeChangeDataList, parent, new ChangeData(ChangeKind.RENAMED_FROM, afterId));
                }
            }
        }

        @NotNull
        private static List<ChangeData> getOrCreateChangeDataListForPath(@NotNull Map<Integer, List<ChangeData>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            List changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathsIndexer.$$$reportNull$$$0(7);
            }
            if ((changeDataList = pathIdToChangeDataListsMap.get(pathId)) == null) {
                changeDataList = ContainerUtil.newSmartList();
                for (int i = 0; i < parentsCount; ++i) {
                    changeDataList.add(null);
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            List list2 = changeDataList;
            if (list2 == null) {
                PathsIndexer.$$$reportNull$$$0(8);
            }
            return list2;
        }

        private static void addChange(@NotNull List<ChangeData> changeDataList, int parentIndex, @NotNull ChangeData change) {
            ChangeData existingChange;
            if (changeDataList == null) {
                PathsIndexer.$$$reportNull$$$0(9);
            }
            if (change == null) {
                PathsIndexer.$$$reportNull$$$0(10);
            }
            if ((existingChange = changeDataList.get(parentIndex)) == null || existingChange.kind != ChangeKind.RENAMED_FROM && existingChange.kind != ChangeKind.RENAMED_TO) {
                changeDataList.set(parentIndex, change);
            }
        }

        @NotNull
        private Collection<String> getParentPaths(@NotNull Collection<String> paths) {
            if (paths == null) {
                PathsIndexer.$$$reportNull$$$0(11);
            }
            HashSet result2 = ContainerUtil.newHashSet();
            block0: for (String path : paths) {
                while (!path.isEmpty() && !result2.contains(path)) {
                    result2.add(path);
                    if (this.myRoots.contains(path)) continue block0;
                    path = PathUtil.getParentPath((String)path);
                }
            }
            HashSet hashSet = result2;
            if (hashSet == null) {
                PathsIndexer.$$$reportNull$$$0(12);
            }
            return hashSet;
        }

        @NotNull
        public PersistentEnumeratorBase<String> getPathsEnumerator() {
            PersistentEnumeratorBase<String> persistentEnumeratorBase = this.myPathsEnumerator;
            if (persistentEnumeratorBase == null) {
                PathsIndexer.$$$reportNull$$$0(13);
            }
            return persistentEnumeratorBase;
        }

        private /* synthetic */ void lambda$map$2(Map result2, int finalParent, int parentsCount, Couple renamedPaths) {
            try {
                this.addChangeToResult(result2, finalParent, parentsCount, (String)renamedPaths.second, (String)renamedPaths.first);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }

        private /* synthetic */ void lambda$map$1(Map result2, int finalParent, int parentsCount, String changedPath) {
            try {
                this.addChangeToResult(result2, finalParent, parentsCount, changedPath, null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitChangesMap";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeDataList";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = VcsLogPathsIndex.PATHS;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeDataListForPath";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentPaths";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsEnumerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 13: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeToResult";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeDataListForPath";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addChange";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentPaths";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

