/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputForm;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerEditorBase myExpressionEditor;
    private final ExpressionInputForm myMainForm;

    public ExpressionInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable String historyId, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression, @NotNull Disposable parentDisposable, boolean showHelp) {
        if (project == null) {
            ExpressionInputComponent.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            ExpressionInputComponent.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            ExpressionInputComponent.$$$reportNull$$$0(2);
        }
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        this.myMainForm = new ExpressionInputForm();
        BorderLayoutPanel expressionPanel = JBUI.Panels.simplePanel();
        this.myExpressionEditor = new XDebuggerExpressionComboBox(project, editorsProvider, historyId, sourcePosition, true, false){

            @Override
            protected void prepareEditor(Editor editor) {
                Font font = EditorUtil.getEditorFont();
                editor.getColorsScheme().setEditorFontName(font.getFontName());
                editor.getColorsScheme().setEditorFontSize(font.getSize());
            }
        };
        this.myExpressionEditor.setExpression(expression);
        expressionPanel.addToCenter((Component)this.myExpressionEditor.getComponent());
        JBLabel help = new JBLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.addtowatches.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)XDebuggerEvaluationDialog.ADD_WATCH_KEYSTROKE)}), 4);
        help.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)6, (int)0));
        help.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        help.setFontColor(UIUtil.FontColor.BRIGHTER);
        expressionPanel.addToBottom((Component)help);
        help.setVisible(showHelp);
        this.myMainForm.addExpressionComponent((JComponent)expressionPanel);
        this.myMainForm.addLanguageComponent(this.myExpressionEditor.getLanguageChooser());
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        contentPanel.add((Component)resultPanel, "Center");
        contentPanel.add((Component)this.myMainForm.getMainPanel(), "North");
    }

    @Override
    public JPanel getMainComponent() {
        return this.myMainForm.getMainPanel();
    }

    @Override
    @NotNull
    public XDebuggerEditorBase getInputEditor() {
        XDebuggerEditorBase xDebuggerEditorBase = this.myExpressionEditor;
        if (xDebuggerEditorBase == null) {
            ExpressionInputComponent.$$$reportNull$$$0(3);
        }
        return xDebuggerEditorBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

