/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertTripleQuotedStringIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.triple.quoted.string", new Object[0]);
        if (string == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.triple.quoted.string", new Object[0]);
        if (string == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(4);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        PyStringLiteralExpression pyString = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(caretOffset), PyStringLiteralExpression.class);
        if (pyString != null) {
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)pyString, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == pyString) {
                return false;
            }
            for (PyUtil.StringNodeInfo info : PyConvertTripleQuotedStringIntention.extractStringNodesInfo(pyString)) {
                if (!info.isTripleQuoted() || !info.isTerminated() || !info.getNode().getTextRange().contains(caretOffset)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(7);
        }
        PyStringLiteralExpression pyString = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (pyString != null) {
            StringBuilder result2 = new StringBuilder();
            List<PyUtil.StringNodeInfo> nodeInfos = PyConvertTripleQuotedStringIntention.extractStringNodesInfo(pyString);
            for (int i = 0; i < nodeInfos.size(); ++i) {
                PyUtil.StringNodeInfo info = nodeInfos.get(i);
                List lines2 = StringUtil.split((String)info.getContent(), (String)"\n", (boolean)true, (boolean)false);
                boolean lastLineExcluded = false;
                if (lines2.size() > 1 && ((String)lines2.get(lines2.size() - 1)).isEmpty()) {
                    lastLineExcluded = true;
                    lines2 = lines2.subList(0, lines2.size() - 1);
                }
                boolean inLastNode = i == nodeInfos.size() - 1;
                for (int j = 0; j < lines2.size(); ++j) {
                    boolean inLastLine;
                    String line = (String)lines2.get(j);
                    boolean bl = inLastLine = j == lines2.size() - 1;
                    if (info.isRaw()) {
                        PyConvertTripleQuotedStringIntention.appendSplittedRawStringLine(result2, info, line);
                        if (!inLastLine || lastLineExcluded) {
                            result2.append(" ").append(info.getSingleQuote()).append("\\n").append(info.getSingleQuote());
                        }
                    } else {
                        result2.append(info.getPrefix());
                        result2.append(info.getSingleQuote());
                        result2.append(PyConvertTripleQuotedStringIntention.convertToValidSubString(line, info.getSingleQuote(), info.isTripleQuoted()));
                        if (!inLastLine || lastLineExcluded) {
                            result2.append("\\n");
                        }
                        result2.append(info.getSingleQuote());
                    }
                    if (inLastNode && inLastLine) continue;
                    result2.append("\n");
                }
            }
            if (result2.indexOf("\n") >= 0) {
                result2.insert(0, "(");
                result2.append(")");
            }
            PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(pyString), result2.toString());
            PsiElement parent = pyString.getParent();
            if (expression instanceof PyParenthesizedExpression && (parent instanceof PyParenthesizedExpression || parent instanceof PyTupleExpression || parent instanceof PyArgumentList && ArrayUtil.getFirstElement((Object[])((PyArgumentList)parent).getArguments()) == pyString)) {
                expression = ((PyParenthesizedExpression)expression).getContainedExpression();
            }
            if (expression != null) {
                pyString.replace((PsiElement)expression);
            }
        }
    }

    private static void appendSplittedRawStringLine(@NotNull StringBuilder result2, @NotNull PyUtil.StringNodeInfo info, @NotNull String line) {
        if (result2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(8);
        }
        if (info == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(9);
        }
        if (line == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(10);
        }
        boolean singleQuoteUsed = false;
        boolean doubleQuoteUsed = false;
        int chunkStart = 0;
        boolean firstChunk = true;
        for (int k = 0; k <= line.length(); ++k) {
            char chunkQuote;
            if (k < line.length()) {
                singleQuoteUsed |= line.charAt(k) == '\'';
                doubleQuoteUsed |= line.charAt(k) == '\"';
            }
            if ((k == line.length() || line.charAt(k) == '\'') && doubleQuoteUsed) {
                chunkQuote = '\'';
                doubleQuoteUsed = false;
            } else if ((k == line.length() || line.charAt(k) == '\"') && singleQuoteUsed) {
                chunkQuote = '\"';
                singleQuoteUsed = false;
            } else {
                if (k != line.length()) continue;
                chunkQuote = info.getSingleQuote();
            }
            if (!firstChunk) {
                result2.append(" ");
            }
            result2.append(info.getPrefix()).append(chunkQuote).append(line.substring(chunkStart, k)).append(chunkQuote);
            firstChunk = false;
            chunkStart = k;
        }
    }

    @NotNull
    private static String convertToValidSubString(@NotNull String content, char newQuote, boolean isMultiline) {
        if (content == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(11);
        }
        String string = isMultiline ? StringUtil.escapeChar((String)content, (char)newQuote) : content;
        if (string == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static List<PyUtil.StringNodeInfo> extractStringNodesInfo(@NotNull PyStringLiteralExpression expression) {
        if (expression == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(13);
        }
        List list2 = ContainerUtil.map(expression.getStringNodes(), node -> new PyUtil.StringNodeInfo((ASTNode)node));
        if (list2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToValidSubString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStringNodesInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendSplittedRawStringLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToValidSubString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractStringNodesInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

