/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Collections;
import java.util.List;

public class PyCommaSelectionHandler
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PyReferenceExpression || e instanceof PyKeyValueExpression || e instanceof PyKeywordArgument || e instanceof PyNumericLiteralExpression || e instanceof PyStringLiteralExpression || e instanceof PyNamedParameter || e instanceof PyStarArgument;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        if (e != null) {
            List<TextRange> textRange = PyCommaSelectionHandler.addNextComma(e, cursorOffset);
            if (textRange.equals(Collections.emptyList())) {
                return PyCommaSelectionHandler.addPreviousComma(e, cursorOffset);
            }
            return textRange;
        }
        return Collections.emptyList();
    }

    private static List<TextRange> addPreviousComma(PsiElement e, int cursorOffset) {
        PsiElement prevSibling = e.getPrevSibling();
        TextRange textRange = e.getTextRange();
        TextRange offsetRange = null;
        if (prevSibling != null) {
            if (prevSibling instanceof PsiWhiteSpace) {
                IElementType commaType;
                ASTNode node;
                PsiElement prevCommaSibling = prevSibling.getPrevSibling();
                if (prevCommaSibling != null && (node = prevCommaSibling.getNode()) != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA && (offsetRange = new TextRange(textRange.getStartOffset() - 2, textRange.getEndOffset())).contains(cursorOffset) && offsetRange.getLength() > 1) {
                    return Collections.singletonList(offsetRange);
                }
            } else {
                IElementType commaType;
                ASTNode node = prevSibling.getNode();
                if (node != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA) {
                    offsetRange = new TextRange(textRange.getStartOffset() - 1, textRange.getEndOffset());
                }
            }
            if (offsetRange != null && offsetRange.contains(cursorOffset) && offsetRange.getLength() > 1) {
                return Collections.singletonList(offsetRange);
            }
        }
        return Collections.emptyList();
    }

    private static List<TextRange> addNextComma(PsiElement e, int cursorOffset) {
        PsiElement nextSpaceSibling;
        IElementType commaType;
        ASTNode node;
        PsiElement nextCommaSibling = e.getNextSibling();
        if (nextCommaSibling != null && (node = nextCommaSibling.getNode()) != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA && (nextSpaceSibling = nextCommaSibling.getNextSibling()) != null) {
            TextRange textRange = e.getTextRange();
            TextRange offsetRange = nextSpaceSibling instanceof PsiWhiteSpace ? new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + 2) : new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + 1);
            if (offsetRange.contains(cursorOffset) && offsetRange.getLength() > 1) {
                return Collections.singletonList(offsetRange);
            }
        }
        return Collections.emptyList();
    }
}

