/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNewStyleStringFormatParser {
    private int myImplicitlyNumberedFieldsCounter;
    private final List<Field> myTopLevelFields;
    private final List<Integer> mySingleRightBraces;
    private final String myNodeText;
    private final TextRange myNodeContentRange;

    @NotNull
    public static ParseResult parse(@NotNull String nodeText) {
        if (nodeText == null) {
            PyNewStyleStringFormatParser.$$$reportNull$$$0(0);
        }
        PyNewStyleStringFormatParser parser = new PyNewStyleStringFormatParser(nodeText);
        parser.parseTopLevel();
        ParseResult parseResult = new ParseResult(parser);
        if (parseResult == null) {
            PyNewStyleStringFormatParser.$$$reportNull$$$0(1);
        }
        return parseResult;
    }

    private PyNewStyleStringFormatParser(@NotNull String nodeText) {
        if (nodeText == null) {
            PyNewStyleStringFormatParser.$$$reportNull$$$0(2);
        }
        this.myImplicitlyNumberedFieldsCounter = 0;
        this.myTopLevelFields = new ArrayList<Field>();
        this.mySingleRightBraces = new ArrayList<Integer>();
        this.myNodeText = nodeText;
        this.myNodeContentRange = PyStringLiteralExpressionImpl.getNodeTextRange(nodeText);
    }

    private void parseTopLevel() {
        int offset = this.myNodeContentRange.getStartOffset();
        while (offset < this.myNodeContentRange.getEndOffset()) {
            char c2;
            int nextOffset = this.skipNamedUnicodeEscape(offset);
            if (offset != nextOffset) {
                offset = nextOffset;
                continue;
            }
            char c1 = this.myNodeText.charAt(offset);
            char c = c2 = offset + 1 < this.myNodeContentRange.getEndOffset() ? this.myNodeText.charAt(offset + 1) : (char)'\u0000';
            if (c1 == '{' && c2 == '{' || c1 == '}' && c2 == '}') {
                offset += 2;
                continue;
            }
            if (c1 == '{') {
                Field field = this.parseField(offset, 1);
                this.myTopLevelFields.add(field);
                offset = field.getFieldEnd();
                continue;
            }
            if (c1 == '}') {
                this.mySingleRightBraces.add(offset);
            }
            ++offset;
        }
    }

    @NotNull
    private Field parseField(int startOffset, int recursionDepth) {
        assert (this.myNodeText.charAt(startOffset) == '{');
        int autoFieldNumber = this.myImplicitlyNumberedFieldsCounter;
        TIntArrayList attrAndLookupBounds = new TIntArrayList();
        int conversionStart = -1;
        int formatSpecStart = -1;
        ArrayList<Field> nestedFields = new ArrayList<Field>();
        int rightBraceOffset = -1;
        boolean insideItem = false;
        boolean recovering = false;
        int contentEnd = this.myNodeContentRange.getEndOffset();
        int offset = startOffset + 1;
        while (offset < contentEnd) {
            block21: {
                char c;
                block19: {
                    block20: {
                        int nextOffset = this.skipNamedUnicodeEscape(offset);
                        if (offset != nextOffset) {
                            offset = nextOffset;
                            continue;
                        }
                        c = this.myNodeText.charAt(offset);
                        if (conversionStart != -1 || formatSpecStart != -1) break block19;
                        if (!insideItem) break block20;
                        if (c == ']') {
                            insideItem = false;
                            attrAndLookupBounds.add(offset + 1);
                            recovering = offset + 1 < contentEnd && !PyNewStyleStringFormatParser.isAnyCharOf(this.myNodeText.charAt(offset + 1), ".[");
                        }
                        break block21;
                    }
                    if (!PyNewStyleStringFormatParser.isAnyCharOf(c, "[.:!}")) break block21;
                    boolean bl = insideItem = c == '[';
                    if (!recovering) {
                        PyNewStyleStringFormatParser.addIfNotLastItem(attrAndLookupBounds, offset);
                        if (attrAndLookupBounds.size() == 1 && attrAndLookupBounds.get(0) == startOffset + 1) {
                            ++this.myImplicitlyNumberedFieldsCounter;
                        }
                    }
                    if (c == ':') {
                        formatSpecStart = offset;
                    } else if (c == '!') {
                        conversionStart = offset;
                    } else if (c == '}') {
                        rightBraceOffset = offset;
                        break;
                    }
                    break block21;
                }
                if (c == '}') {
                    rightBraceOffset = offset;
                    break;
                }
                if (conversionStart >= 0) {
                    if (c == ':') {
                        formatSpecStart = offset;
                    }
                } else if (formatSpecStart >= 0 && c == '{') {
                    Field field = this.parseField(offset, recursionDepth + 1);
                    nestedFields.add(field);
                    offset = field.getFieldEnd();
                    continue;
                }
            }
            ++offset;
        }
        if (offset >= contentEnd && conversionStart == -1 && formatSpecStart == -1 && !insideItem && !recovering) {
            PyNewStyleStringFormatParser.addIfNotLastItem(attrAndLookupBounds, contentEnd);
        }
        assert (!attrAndLookupBounds.isEmpty());
        Field field = new Field(this.myNodeText, startOffset, attrAndLookupBounds.toNativeArray(), conversionStart, formatSpecStart, nestedFields, rightBraceOffset, rightBraceOffset == -1 ? contentEnd : rightBraceOffset + 1, autoFieldNumber, recursionDepth);
        if (field == null) {
            PyNewStyleStringFormatParser.$$$reportNull$$$0(3);
        }
        return field;
    }

    private static void addIfNotLastItem(TIntArrayList attrAndLookupBounds, int offset) {
        if (attrAndLookupBounds.isEmpty() || attrAndLookupBounds.get(attrAndLookupBounds.size() - 1) != offset) {
            attrAndLookupBounds.add(offset);
        }
    }

    private static boolean isAnyCharOf(char c, @NotNull String variants) {
        if (variants == null) {
            PyNewStyleStringFormatParser.$$$reportNull$$$0(4);
        }
        return variants.indexOf(c) >= 0;
    }

    private int skipNamedUnicodeEscape(int offset) {
        if (StringUtil.startsWith((CharSequence)this.myNodeText, (int)offset, (CharSequence)"\\N{")) {
            int rightBraceOffset = this.myNodeText.indexOf(125, offset + 3);
            return rightBraceOffset < 0 ? this.myNodeContentRange.getEndOffset() : rightBraceOffset + 1;
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAnyCharOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Field
    extends PyStringFormatParser.SubstitutionChunk {
        private final String myNodeText;
        private final int myLeftBraceOffset;
        private final int[] myAttributesAndLookups;
        private final int myConversionOffset;
        private final int myFormatSpecOffset;
        private final List<Field> myNestedFields;
        private final int myRightBraceOffset;
        private final int myEndOffset;
        private final int myDepth;

        private Field(@NotNull String nodeText, int leftBraceOffset, @NotNull int[] attrAndLookupBounds, int conversionOffset, int formatSpecOffset, @NotNull List<Field> fields, int rightBraceOffset, int endOffset, int autoPosition, int depth) {
            if (nodeText == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (attrAndLookupBounds == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (fields == null) {
                Field.$$$reportNull$$$0(2);
            }
            super(leftBraceOffset, endOffset);
            this.myNodeText = nodeText;
            this.myLeftBraceOffset = leftBraceOffset;
            this.myAttributesAndLookups = attrAndLookupBounds;
            this.myConversionOffset = conversionOffset;
            this.myFormatSpecOffset = formatSpecOffset;
            this.myRightBraceOffset = rightBraceOffset;
            this.myNestedFields = fields;
            this.myEndOffset = endOffset;
            this.myDepth = depth;
            String name = this.getFirstName();
            if (name.isEmpty()) {
                this.setAutoPosition(autoPosition);
            } else {
                try {
                    this.setPosition(Integer.parseInt(name));
                }
                catch (NumberFormatException e) {
                    this.setMappingKey(StringUtil.nullize((String)name));
                }
            }
        }

        private int defaultToContentEnd(int offset) {
            return offset >= 0 ? offset : this.myEndOffset;
        }

        public int getLeftBraceOffset() {
            return this.myLeftBraceOffset;
        }

        public int getFieldEnd() {
            return this.myEndOffset;
        }

        public int getRightBraceOffset() {
            return this.myRightBraceOffset;
        }

        @NotNull
        public String getFirstName() {
            String string = this.getFirstNameRange().substring(this.myNodeText);
            if (string == null) {
                Field.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public TextRange getFirstNameRange() {
            TextRange textRange = TextRange.create((int)(this.myLeftBraceOffset + 1), (int)this.myAttributesAndLookups[0]);
            if (textRange == null) {
                Field.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        @NotNull
        public TextRange getNamePartRange() {
            int end = Math.min(Math.min(this.defaultToContentEnd(this.myFormatSpecOffset), this.defaultToContentEnd(this.myConversionOffset)), this.defaultToContentEnd(this.myRightBraceOffset));
            TextRange textRange = TextRange.create((int)(this.myLeftBraceOffset + 1), (int)end);
            if (textRange == null) {
                Field.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @Nullable
        public String getConversion() {
            TextRange range = this.getConversionRange();
            return range != null ? range.substring(this.myNodeText) : null;
        }

        @Nullable
        public TextRange getConversionRange() {
            int end = Math.min(this.defaultToContentEnd(this.myFormatSpecOffset), this.defaultToContentEnd(this.myRightBraceOffset));
            return this.myConversionOffset >= 0 ? TextRange.create((int)this.myConversionOffset, (int)end) : null;
        }

        @Nullable
        public String getFormatSpec() {
            TextRange range = this.getFormatSpecRange();
            return range != null ? range.substring(this.myNodeText) : null;
        }

        @Nullable
        public TextRange getFormatSpecRange() {
            return this.myFormatSpecOffset >= 0 ? TextRange.create((int)this.myFormatSpecOffset, (int)this.defaultToContentEnd(this.myRightBraceOffset)) : null;
        }

        @NotNull
        public List<Field> getNestedFields() {
            List<Field> list2 = Collections.unmodifiableList(this.myNestedFields);
            if (list2 == null) {
                Field.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        public List<String> getAttributesAndLookups() {
            List<String> list2 = this.getAttributesAndLookupsRanges().stream().map(ranges -> ranges.substring(this.myNodeText)).collect(Collectors.toList());
            if (list2 == null) {
                Field.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        public List<TextRange> getAttributesAndLookupsRanges() {
            ArrayList<TextRange> result2 = new ArrayList<TextRange>();
            for (int i = 0; i < this.myAttributesAndLookups.length - 1; ++i) {
                result2.add(TextRange.create((int)this.myAttributesAndLookups[i], (int)this.myAttributesAndLookups[i + 1]));
            }
            List<TextRange> list2 = Collections.unmodifiableList(result2);
            if (list2 == null) {
                Field.$$$reportNull$$$0(8);
            }
            return list2;
        }

        public int getDepth() {
            return this.myDepth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrAndLookupBounds";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser$Field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser$Field";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstNameRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamePartRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNestedFields";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesAndLookups";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesAndLookupsRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ParseResult {
        private PyNewStyleStringFormatParser myParser;

        public ParseResult(@NotNull PyNewStyleStringFormatParser parser) {
            if (parser == null) {
                ParseResult.$$$reportNull$$$0(0);
            }
            this.myParser = parser;
        }

        @NotNull
        public List<Field> getFields() {
            List<Field> list2 = Collections.unmodifiableList(this.myParser.myTopLevelFields);
            if (list2 == null) {
                ParseResult.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        public List<Field> getAllFields() {
            ArrayList<Field> result2 = new ArrayList<Field>();
            ParseResult.collectNestedLists(this.myParser.myTopLevelFields, result2);
            List<Field> list2 = Collections.unmodifiableList(result2);
            if (list2 == null) {
                ParseResult.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        public List<Integer> getSingleRightBraces() {
            List<Integer> list2 = Collections.unmodifiableList(this.myParser.mySingleRightBraces);
            if (list2 == null) {
                ParseResult.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static void collectNestedLists(@NotNull List<Field> fields, @NotNull List<Field> result2) {
            if (fields == null) {
                ParseResult.$$$reportNull$$$0(4);
            }
            if (result2 == null) {
                ParseResult.$$$reportNull$$$0(5);
            }
            for (Field field : fields) {
                result2.add(field);
                ParseResult.collectNestedLists(field.getNestedFields(), result2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser$ParseResult";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyNewStyleStringFormatParser$ParseResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllFields";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingleRightBraces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectNestedLists";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

