/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotator;

public class ReturnAnnotator
extends PyAnnotator {
    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (function == null) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "'return' outside of function");
        }
        if (function != null && node.getExpression() != null && function.isGenerator() && function.isAsync() && function.isAsyncAllowed()) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "non-empty 'return' inside asynchronous generator");
        }
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        PyFunction function;
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
        if (!(owner instanceof PyFunction) && !(owner instanceof PyLambdaExpression)) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "'yield' outside of function");
        }
        if (node.isDelegating() && owner instanceof PyFunction && (function = (PyFunction)owner).isAsync() && function.isAsyncAllowed()) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "Python does not support 'yield from' inside async functions");
        }
    }
}

