/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder = new StringBuilder();
    private final StringBuilder myStderrBuilder = new StringBuilder();
    @Nullable
    private Integer myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
    }

    public ProcessOutput(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void appendStdout(@Nullable String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(@Nullable String text) {
        this.myStderrBuilder.append(text);
    }

    @NotNull
    public String getStdout() {
        String string = this.myStdoutBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getStderr() {
        String string = this.myStderrBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<String> getStdoutLines() {
        List<String> list = this.getStdoutLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<String> getStdoutLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<String> getStderrLines() {
        List<String> list = this.getStderrLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getStderrLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        List list = StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        if (logger == null) {
            ProcessOutput.$$$reportNull$$$0(7);
        }
        if (this.getExitCode() != 0 || this.isTimeout()) {
            logger.info(this.getStderr() + (this.isTimeout() ? "\nTimed out" : "\nExit code " + this.getExitCode()));
            return false;
        }
        return true;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        Integer code = this.myExitCode;
        return code == null ? -1 : code;
    }

    public boolean isExitCodeSet() {
        return this.myExitCode != null;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdoutLines";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderrLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLines";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

