/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public enum DependencyScope {
    COMPILE("Compile", true, true, true, true),
    TEST("Test", false, false, true, true),
    RUNTIME("Runtime", false, true, false, true),
    PROVIDED("Provided", true, false, true, true);

    private final String myDisplayName;
    private final boolean myForProductionCompile;
    private final boolean myForProductionRuntime;
    private final boolean myForTestCompile;
    private final boolean myForTestRuntime;
    public static final String SCOPE_ATTR = "scope";

    private DependencyScope(String displayName, boolean forProductionCompile, boolean forProductionRuntime, boolean forTestCompile, boolean forTestRuntime) {
        this.myDisplayName = displayName;
        this.myForProductionCompile = forProductionCompile;
        this.myForProductionRuntime = forProductionRuntime;
        this.myForTestCompile = forTestCompile;
        this.myForTestRuntime = forTestRuntime;
    }

    @NotNull
    public static DependencyScope readExternal(@NotNull Element element) {
        String scope;
        if (element == null) {
            DependencyScope.$$$reportNull$$$0(0);
        }
        if ((scope = element.getAttributeValue(SCOPE_ATTR)) != null) {
            DependencyScope dependencyScope;
            try {
                dependencyScope = DependencyScope.valueOf(scope);
            }
            catch (IllegalArgumentException e) {
                DependencyScope dependencyScope2 = COMPILE;
                if (dependencyScope2 == null) {
                    DependencyScope.$$$reportNull$$$0(2);
                }
                return dependencyScope2;
            }
            if (dependencyScope == null) {
                DependencyScope.$$$reportNull$$$0(1);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = COMPILE;
        if (dependencyScope == null) {
            DependencyScope.$$$reportNull$$$0(3);
        }
        return dependencyScope;
    }

    public void writeExternal(Element element) {
        if (this != COMPILE) {
            element.setAttribute(SCOPE_ATTR, this.name());
        }
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isForProductionCompile() {
        return this.myForProductionCompile;
    }

    public boolean isForProductionRuntime() {
        return this.myForProductionRuntime;
    }

    public boolean isForTestCompile() {
        return this.myForTestCompile;
    }

    public boolean isForTestRuntime() {
        return this.myForTestRuntime;
    }

    public String toString() {
        return this.myDisplayName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

