/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.StringUtils;

public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties eprops) {
        return new MapConfiguration((Map)eprops);
    }

    public static Configuration getConfiguration(Properties props) {
        return new MapConfiguration(props);
    }

    public static ExtendedProperties getExtendedProperties(Configuration config) {
        ExtendedProperties props = new ExtendedProperties();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Vector property = config.getProperty(key);
            if (property instanceof List) {
                property = new Vector(property);
            }
            props.setProperty(key, (Object)property);
        }
        return props;
    }

    public static Properties getProperties(Configuration config) {
        Properties props = new Properties();
        char delimiter = config instanceof AbstractConfiguration ? (char)((AbstractConfiguration)config).getListDelimiter() : (char)',';
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List list = config.getList(key);
            props.setProperty(key, StringUtils.join(list.iterator(), (char)delimiter));
        }
        return props;
    }

    public static Map getMap(Configuration config) {
        return new ConfigurationMap(config);
    }
}

