/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hemf.hemfplus.record.HemfPlusRecord;
import org.apache.poi.hemf.hemfplus.record.HemfPlusRecordType;
import org.apache.poi.hemf.record.AbstractHemfComment;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfCommentEMFPlus
extends AbstractHemfComment {
    long dataSize;

    public HemfCommentEMFPlus(byte[] rawBytes) {
        super(rawBytes);
    }

    public List<HemfPlusRecord> getRecords() {
        return HemfPlusParser.parse(this.getRawBytes());
    }

    private static class HemfPlusParser {
        private HemfPlusParser() {
        }

        public static List<HemfPlusRecord> parse(byte[] bytes) {
            int dataSize;
            ArrayList<HemfPlusRecord> records = new ArrayList<HemfPlusRecord>();
            for (int offset = 0; offset < bytes.length && offset + 12 <= bytes.length; offset += dataSize) {
                int type = LittleEndian.getUShort((byte[])bytes, (int)offset);
                int flags = LittleEndian.getUShort((byte[])bytes, (int)(offset += 2));
                long sizeLong = LittleEndian.getUInt((byte[])bytes, (int)(offset += 2));
                offset += 4;
                if (sizeLong >= Integer.MAX_VALUE) {
                    throw new RecordFormatException("size of emf record >= Integer.MAX_VALUE");
                }
                int size = (int)sizeLong;
                long dataSizeLong = LittleEndian.getUInt((byte[])bytes, (int)offset);
                offset += 4;
                if (dataSizeLong >= Integer.MAX_VALUE) {
                    throw new RuntimeException("data size of emfplus record cannot be >= Integer.MAX_VALUE");
                }
                dataSize = (int)dataSizeLong;
                if (dataSize + offset > bytes.length) break;
                HemfPlusRecord record = HemfPlusParser.buildRecord(type, flags, dataSize, offset, bytes);
                records.add(record);
            }
            return records;
        }

        private static HemfPlusRecord buildRecord(int recordId, int flags, int size, int offset, byte[] bytes) {
            HemfPlusRecord record = null;
            HemfPlusRecordType type = HemfPlusRecordType.getById(recordId);
            if (type == null) {
                throw new RuntimeException("Undefined record of type:" + recordId);
            }
            try {
                record = type.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            byte[] dataBytes = new byte[size];
            System.arraycopy(bytes, offset, dataBytes, 0, size);
            try {
                record.init(dataBytes, recordId, flags);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return record;
        }
    }
}

