/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;
import org.apache.uima.internal.util.rb_trees.IntRBTNode;

public class IntRedBlackTree {
    IntRBTNode root = null;
    int size = 0;

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    public final boolean containsKey(int key) {
        return IntRBTNode.find(this.root, key) != null;
    }

    public final boolean containsValue(int o) {
        IntRBTIterator it = this.iterator();
        while (it.hasNext()) {
            if (o != it.next()) continue;
            return true;
        }
        return false;
    }

    public final boolean put(int key, int el) {
        if (this.put(new IntRBTNode(key, el))) {
            ++this.size;
            return true;
        }
        return false;
    }

    public final int remove(int key) throws NoSuchElementException {
        int ret;
        IntRBTNode node = IntRBTNode.find(this.root, key);
        if (node != null) {
            ret = node.element;
            --this.size;
        } else {
            throw new NoSuchElementException();
        }
        IntRBTNode.delete(this, node);
        return ret;
    }

    public final int get(int key) throws NoSuchElementException {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        IntRBTNode node = IntRBTNode.find(this.root, key);
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.element;
    }

    public final boolean isEmpty() {
        return this.root == null;
    }

    public final int[] keySet() {
        int[] set = new int[this.size];
        if (this.root != null) {
            this.root.keys(0, set);
        }
        return set;
    }

    private final boolean put(IntRBTNode node) {
        return IntRBTNode.insert(this, node);
    }

    public final int getFirst() {
        return this.getFirstNode().element;
    }

    private final IntRBTNode getFirstNode() {
        if (this.root == null) {
            return null;
        }
        IntRBTNode x = this.root;
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    public IntRBTIterator iterator() {
        return new IntRBTIterator(this);
    }

    public void printKeys() {
        if (this.root != null) {
            this.root.printKeys(0);
        }
        System.out.println("Size: " + this.size);
    }

    public int[] toArray(int offset) {
        if (this.root == null) {
            return new int[0];
        }
        return this.root.toArray(offset);
    }

    public static class IntRBTIterator {
        IntRBTNode current;

        IntRBTIterator(IntRedBlackTree tree) {
            this.current = tree.getFirstNode();
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public int next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            int ret = this.current.element;
            this.current = this.current.successor();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

