/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.StackTraceHolder;
import java.lang.ref.WeakReference;
import java.util.Random;

public final class AssertingRandom
extends Random {
    private final Random delegate;
    private final WeakReference ownerRef;
    private final String ownerName;
    private final StackTraceElement[] allocationStack;
    private volatile boolean valid = true;
    private static final boolean assertionsEnabled = AssertingRandom.class.desiredAssertionStatus();

    public AssertingRandom(Thread thread, Random random) {
        super(0L);
        this.delegate = random;
        this.ownerRef = new WeakReference<Thread>(thread);
        this.ownerName = thread.toString();
        this.allocationStack = Thread.currentThread().getStackTrace();
    }

    @Override
    protected int next(int n) {
        throw new RuntimeException("Shouldn't be reachable.");
    }

    @Override
    public boolean nextBoolean() {
        this.checkValid();
        return this.delegate.nextBoolean();
    }

    @Override
    public void nextBytes(byte[] byArray) {
        this.checkValid();
        this.delegate.nextBytes(byArray);
    }

    @Override
    public double nextDouble() {
        this.checkValid();
        return this.delegate.nextDouble();
    }

    @Override
    public float nextFloat() {
        this.checkValid();
        return this.delegate.nextFloat();
    }

    @Override
    public double nextGaussian() {
        this.checkValid();
        return this.delegate.nextGaussian();
    }

    @Override
    public int nextInt() {
        this.checkValid();
        return this.delegate.nextInt();
    }

    @Override
    public int nextInt(int n) {
        this.checkValid();
        return this.delegate.nextInt(n);
    }

    @Override
    public long nextLong() {
        this.checkValid();
        return this.delegate.nextLong();
    }

    @Override
    public void setSeed(long l) {
        if (l == 0L && this.delegate == null) {
            return;
        }
        throw AssertingRandom.noSetSeed();
    }

    public String toString() {
        this.checkValid();
        return this.delegate.toString();
    }

    public boolean equals(Object object) {
        this.checkValid();
        return this.delegate.equals(object);
    }

    public int hashCode() {
        this.checkValid();
        return this.delegate.hashCode();
    }

    public void destroy() {
        this.valid = false;
    }

    private final void checkValid() {
        if (!AssertingRandom.isVerifying()) {
            return;
        }
        if (!this.valid) {
            throw new IllegalStateException("This Random instance has been invalidated and is probably used out of its allowed context (test or suite).");
        }
        Thread thread = (Thread)this.ownerRef.get();
        if (thread == null || Thread.currentThread() != thread) {
            StackTraceHolder stackTraceHolder = new StackTraceHolder("Original allocation stack for this Random (allocated by " + this.ownerName + ")");
            stackTraceHolder.setStackTrace(this.allocationStack);
            throw new IllegalStateException("This Random was created for/by another thread (" + this.ownerName + ")." + " Random instances must not be shared (acquire per-thread). Current thread: " + Thread.currentThread().toString(), stackTraceHolder);
        }
    }

    protected Object clone() {
        this.checkValid();
        throw new CloneNotSupportedException("Don't clone test Randoms.");
    }

    public static boolean isVerifying() {
        return assertionsEnabled;
    }

    static RuntimeException noSetSeed() {
        return new RuntimeException(RandomizedRunner.class.getSimpleName() + " prevents changing the seed of its random generators to assure repeatability" + " of tests. If you need a mutable instance of Random, create a new (local) instance," + " preferably with the initial seed aquired from this Random instance.");
    }
}

