/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.rules;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ClassModel;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ClassModel$MethodModel;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.rules.NoShadowingOrOverridesOnMethodsRule$1;
import java.lang.reflect.Method;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class NoShadowingOrOverridesOnMethodsRule
implements TestRule {
    private Class[] annotations;

    public final Statement apply(Statement statement, Description description) {
        return new NoShadowingOrOverridesOnMethodsRule$1(this, description, statement);
    }

    public final void validate(Class clazz) {
        ClassModel classModel = new ClassModel(clazz);
        for (Class clazz2 : this.annotations) {
            this.checkNoShadowsOrOverrides(clazz, classModel, clazz2);
        }
    }

    private void checkNoShadowsOrOverrides(Class clazz, ClassModel classModel, Class clazz2) {
        Map map = classModel.getAnnotatedLeafMethods(clazz2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            ClassModel$MethodModel classModel$MethodModel;
            if (!this.verify((Method)entry.getKey()) || (classModel$MethodModel = (ClassModel$MethodModel)entry.getValue()).getDown() == null && classModel$MethodModel.getUp() == null) continue;
            stringBuilder.append("Methods annotated with @" + clazz2.getName() + " shadow or override each other:\n");
            while (classModel$MethodModel.getUp() != null) {
                classModel$MethodModel = (ClassModel$MethodModel)classModel$MethodModel.getUp();
            }
            while (classModel$MethodModel != null) {
                stringBuilder.append("  - ");
                if (((Method)classModel$MethodModel.element).isAnnotationPresent(clazz2)) {
                    stringBuilder.append("@").append(clazz2.getSimpleName()).append(" ");
                }
                stringBuilder.append(this.signature((Method)classModel$MethodModel.element)).append("\n");
                classModel$MethodModel = (ClassModel$MethodModel)classModel$MethodModel.getDown();
            }
        }
        if (stringBuilder.length() > 0) {
            throw new RuntimeException("There are overridden methods annotated with " + clazz2.getName() + ". These methods would not be executed by JUnit and need to manually chain themselves which can lead to" + " maintenance problems. Consider using different method names or make hook methods private.\n" + stringBuilder.toString().trim());
        }
    }

    protected boolean verify(Method method) {
        return true;
    }

    private String signature(Method method) {
        return method.toString();
    }
}

