/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ImmutableMap$Builder {
    Comparator valueComparator;
    ImmutableMapEntry[] entries;
    int size;
    boolean entriesUsed;

    public ImmutableMap$Builder() {
        this(4);
    }

    ImmutableMap$Builder(int n) {
        this.entries = new ImmutableMapEntry[n];
        this.size = 0;
        this.entriesUsed = false;
    }

    private void ensureCapacity(int n) {
        if (n > this.entries.length) {
            this.entries = (ImmutableMapEntry[])ObjectArrays.arraysCopyOf(this.entries, ImmutableCollection$Builder.expandedCapacity(this.entries.length, n));
            this.entriesUsed = false;
        }
    }

    public ImmutableMap$Builder put(Object object, Object object2) {
        this.ensureCapacity(this.size + 1);
        ImmutableMapEntry immutableMapEntry = ImmutableMap.entryOf(object, object2);
        this.entries[this.size++] = immutableMapEntry;
        return this;
    }

    public ImmutableMap$Builder put(Map.Entry entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    public ImmutableMap$Builder putAll(Map map) {
        return this.putAll(map.entrySet());
    }

    public ImmutableMap$Builder putAll(Iterable iterable) {
        if (iterable instanceof Collection) {
            this.ensureCapacity(this.size + ((Collection)iterable).size());
        }
        for (Map.Entry entry : iterable) {
            this.put(entry);
        }
        return this;
    }

    public ImmutableMap build() {
        switch (this.size) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return ImmutableMap.of(this.entries[0].getKey(), this.entries[0].getValue());
            }
        }
        if (this.valueComparator != null) {
            if (this.entriesUsed) {
                this.entries = (ImmutableMapEntry[])ObjectArrays.arraysCopyOf(this.entries, this.size);
            }
            Arrays.sort(this.entries, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
        }
        this.entriesUsed = this.size == this.entries.length;
        return RegularImmutableMap.fromEntryArray(this.size, this.entries);
    }
}

