/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Equivalence;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ticker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.GenericMapMaker$NullListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMaker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMaker$RemovalListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMaker$RemovalNotification;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$EntryFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$NullEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$Segment;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$Strength;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMakerInternalMap$Values;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class MapMakerInternalMap
extends AbstractMap
implements Serializable,
ConcurrentMap {
    private static final Logger logger = Logger.getLogger(MapMakerInternalMap.class.getName());
    final transient int segmentMask;
    final transient int segmentShift;
    final transient MapMakerInternalMap$Segment[] segments;
    final int concurrencyLevel;
    final Equivalence keyEquivalence;
    final Equivalence valueEquivalence;
    final MapMakerInternalMap$Strength keyStrength;
    final MapMakerInternalMap$Strength valueStrength;
    final int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue removalNotificationQueue;
    final MapMaker$RemovalListener removalListener;
    final transient MapMakerInternalMap$EntryFactory entryFactory;
    final Ticker ticker;
    static final MapMakerInternalMap$ValueReference UNSET = new MapMakerInternalMap$1();
    static final Queue DISCARDING_QUEUE = new MapMakerInternalMap$2();
    transient Set keySet;
    transient Collection values;
    transient Set entrySet;

    MapMakerInternalMap(MapMaker mapMaker) {
        int n;
        int n2;
        this.concurrencyLevel = Math.min(mapMaker.getConcurrencyLevel(), 65536);
        this.keyStrength = mapMaker.getKeyStrength();
        this.valueStrength = mapMaker.getValueStrength();
        this.keyEquivalence = mapMaker.getKeyEquivalence();
        this.valueEquivalence = this.valueStrength.defaultEquivalence();
        this.maximumSize = mapMaker.maximumSize;
        this.expireAfterAccessNanos = mapMaker.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = mapMaker.getExpireAfterWriteNanos();
        this.entryFactory = MapMakerInternalMap$EntryFactory.getFactory(this.keyStrength, this.expires(), this.evictsBySize());
        this.ticker = mapMaker.getTicker();
        this.removalListener = mapMaker.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == GenericMapMaker$NullListener.INSTANCE ? MapMakerInternalMap.discardingQueue() : new ConcurrentLinkedQueue();
        int n3 = Math.min(mapMaker.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            n3 = Math.min(n3, this.maximumSize);
        }
        int n4 = 0;
        for (n2 = 1; !(n2 >= this.concurrencyLevel || this.evictsBySize() && n2 * 2 > this.maximumSize); n2 <<= 1) {
            ++n4;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n5 = n3 / n2;
        if (n5 * n2 < n3) {
            ++n5;
        }
        for (n = 1; n < n5; n <<= 1) {
        }
        if (this.evictsBySize()) {
            int n6 = this.maximumSize / n2 + 1;
            int n7 = this.maximumSize % n2;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == n7) {
                    --n6;
                }
                this.segments[i] = this.createSegment(n, n6);
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = this.createSegment(n, -1);
            }
        }
    }

    boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean usesKeyReferences() {
        return this.keyStrength != MapMakerInternalMap$Strength.STRONG;
    }

    boolean usesValueReferences() {
        return this.valueStrength != MapMakerInternalMap$Strength.STRONG;
    }

    static MapMakerInternalMap$ValueReference unset() {
        return UNSET;
    }

    static MapMakerInternalMap$ReferenceEntry nullEntry() {
        return MapMakerInternalMap$NullEntry.INSTANCE;
    }

    static Queue discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    int hash(Object object) {
        int n = this.keyEquivalence.hash(object);
        return MapMakerInternalMap.rehash(n);
    }

    void reclaimValue(MapMakerInternalMap$ValueReference mapMakerInternalMap$ValueReference) {
        MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry = mapMakerInternalMap$ValueReference.getEntry();
        int n = mapMakerInternalMap$ReferenceEntry.getHash();
        this.segmentFor(n).reclaimValue(mapMakerInternalMap$ReferenceEntry.getKey(), n, mapMakerInternalMap$ValueReference);
    }

    void reclaimKey(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry) {
        int n = mapMakerInternalMap$ReferenceEntry.getHash();
        this.segmentFor(n).reclaimKey(mapMakerInternalMap$ReferenceEntry, n);
    }

    MapMakerInternalMap$Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    MapMakerInternalMap$Segment createSegment(int n, int n2) {
        return new MapMakerInternalMap$Segment(this, n, n2);
    }

    Object getLiveValue(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry) {
        if (mapMakerInternalMap$ReferenceEntry.getKey() == null) {
            return null;
        }
        Object object = mapMakerInternalMap$ReferenceEntry.getValueReference().get();
        if (object == null) {
            return null;
        }
        if (this.expires() && this.isExpired(mapMakerInternalMap$ReferenceEntry)) {
            return null;
        }
        return object;
    }

    boolean isExpired(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry) {
        return this.isExpired(mapMakerInternalMap$ReferenceEntry, this.ticker.read());
    }

    boolean isExpired(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry, long l) {
        return l - mapMakerInternalMap$ReferenceEntry.getExpirationTime() > 0L;
    }

    static void connectExpirables(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry, MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry2) {
        mapMakerInternalMap$ReferenceEntry.setNextExpirable(mapMakerInternalMap$ReferenceEntry2);
        mapMakerInternalMap$ReferenceEntry2.setPreviousExpirable(mapMakerInternalMap$ReferenceEntry);
    }

    static void nullifyExpirable(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry) {
        MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry2 = MapMakerInternalMap.nullEntry();
        mapMakerInternalMap$ReferenceEntry.setNextExpirable(mapMakerInternalMap$ReferenceEntry2);
        mapMakerInternalMap$ReferenceEntry.setPreviousExpirable(mapMakerInternalMap$ReferenceEntry2);
    }

    void processPendingNotifications() {
        MapMaker$RemovalNotification mapMaker$RemovalNotification;
        while ((mapMaker$RemovalNotification = (MapMaker$RemovalNotification)this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(mapMaker$RemovalNotification);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", exception);
            }
        }
    }

    static void connectEvictables(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry, MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry2) {
        mapMakerInternalMap$ReferenceEntry.setNextEvictable(mapMakerInternalMap$ReferenceEntry2);
        mapMakerInternalMap$ReferenceEntry2.setPreviousEvictable(mapMakerInternalMap$ReferenceEntry);
    }

    static void nullifyEvictable(MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry) {
        MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry2 = MapMakerInternalMap.nullEntry();
        mapMakerInternalMap$ReferenceEntry.setNextEvictable(mapMakerInternalMap$ReferenceEntry2);
        mapMakerInternalMap$ReferenceEntry.setPreviousEvictable(mapMakerInternalMap$ReferenceEntry2);
    }

    final MapMakerInternalMap$Segment[] newSegmentArray(int n) {
        return new MapMakerInternalMap$Segment[n];
    }

    @Override
    public boolean isEmpty() {
        int n;
        long l = 0L;
        MapMakerInternalMap$Segment[] mapMakerInternalMap$SegmentArray = this.segments;
        for (n = 0; n < mapMakerInternalMap$SegmentArray.length; ++n) {
            if (mapMakerInternalMap$SegmentArray[n].count != 0) {
                return false;
            }
            l += (long)mapMakerInternalMap$SegmentArray[n].modCount;
        }
        if (l != 0L) {
            for (n = 0; n < mapMakerInternalMap$SegmentArray.length; ++n) {
                if (mapMakerInternalMap$SegmentArray[n].count != 0) {
                    return false;
                }
                l -= (long)mapMakerInternalMap$SegmentArray[n].modCount;
            }
            if (l != 0L) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        MapMakerInternalMap$Segment[] mapMakerInternalMap$SegmentArray = this.segments;
        long l = 0L;
        for (int i = 0; i < mapMakerInternalMap$SegmentArray.length; ++i) {
            l += (long)mapMakerInternalMap$SegmentArray[i].count;
        }
        return Ints.saturatedCast(l);
    }

    @Override
    public Object get(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        MapMakerInternalMap$Segment[] mapMakerInternalMap$SegmentArray = this.segments;
        long l = -1L;
        for (int i = 0; i < 3; ++i) {
            long l2 = 0L;
            for (MapMakerInternalMap$Segment mapMakerInternalMap$Segment : mapMakerInternalMap$SegmentArray) {
                int n = mapMakerInternalMap$Segment.count;
                AtomicReferenceArray atomicReferenceArray = mapMakerInternalMap$Segment.table;
                for (int j = 0; j < atomicReferenceArray.length(); ++j) {
                    for (MapMakerInternalMap$ReferenceEntry mapMakerInternalMap$ReferenceEntry = (MapMakerInternalMap$ReferenceEntry)atomicReferenceArray.get(j); mapMakerInternalMap$ReferenceEntry != null; mapMakerInternalMap$ReferenceEntry = mapMakerInternalMap$ReferenceEntry.getNext()) {
                        Object object2 = mapMakerInternalMap$Segment.getLiveValue(mapMakerInternalMap$ReferenceEntry);
                        if (object2 == null || !this.valueEquivalence.equivalent(object, object2)) continue;
                        return true;
                    }
                }
                l2 += (long)mapMakerInternalMap$Segment.modCount;
            }
            if (l2 == l) break;
            l = l2;
        }
        return false;
    }

    @Override
    public Object put(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, false);
    }

    @Override
    public Object putIfAbsent(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, true);
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n);
    }

    @Override
    public boolean remove(@Nullable Object object, @Nullable Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, object2);
    }

    @Override
    public boolean replace(Object object, @Nullable Object object2, Object object3) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object3);
        if (object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2, object3);
    }

    @Override
    public Object replace(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2);
    }

    @Override
    public void clear() {
        for (MapMakerInternalMap$Segment mapMakerInternalMap$Segment : this.segments) {
            mapMakerInternalMap$Segment.clear();
        }
    }

    @Override
    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new MapMakerInternalMap$KeySet(this));
    }

    @Override
    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new MapMakerInternalMap$Values(this));
    }

    @Override
    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new MapMakerInternalMap$EntrySet(this));
    }

    private static ArrayList toArrayList(Collection collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    static /* synthetic */ ArrayList access$300(Collection collection) {
        return MapMakerInternalMap.toArrayList(collection);
    }
}

