/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry$NonTerminalImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntrySet$RegularEntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Nullable;

final class RegularImmutableMap
extends ImmutableMap {
    private final transient Map.Entry[] entries;
    private final transient ImmutableMapEntry[] table;
    private final transient int mask;

    static RegularImmutableMap fromEntries(Map.Entry ... entryArray) {
        return RegularImmutableMap.fromEntryArray(entryArray.length, entryArray);
    }

    static RegularImmutableMap fromEntryArray(int n, Map.Entry[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        Map.Entry[] entryArray2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int n2 = Hashing.closedTableSize(n, 1.2);
        ImmutableMapEntry[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n2);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry immutableMapEntry;
            Map.Entry entry = entryArray[i];
            Object k = entry.getKey();
            Object v = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k, v);
            int n4 = Hashing.smear(k.hashCode()) & n3;
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntryArray[n4];
            if (immutableMapEntry2 == null) {
                boolean bl = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
                immutableMapEntry = bl ? (ImmutableMapEntry)entry : new ImmutableMapEntry(k, v);
            } else {
                immutableMapEntry = new ImmutableMapEntry$NonTerminalImmutableMapEntry(k, v, immutableMapEntry2);
            }
            immutableMapEntryArray[n4] = immutableMapEntry;
            entryArray2[i] = immutableMapEntry;
            RegularImmutableMap.checkNoConflictInKeyBucket(k, immutableMapEntry, immutableMapEntry2);
        }
        return new RegularImmutableMap(entryArray2, immutableMapEntryArray, n3);
    }

    private RegularImmutableMap(Map.Entry[] entryArray, ImmutableMapEntry[] immutableMapEntryArray, int n) {
        this.entries = entryArray;
        this.table = immutableMapEntryArray;
        this.mask = n;
    }

    static void checkNoConflictInKeyBucket(Object object, Map.Entry entry, @Nullable ImmutableMapEntry immutableMapEntry) {
        while (immutableMapEntry != null) {
            RegularImmutableMap.checkNoConflict(!object.equals(immutableMapEntry.getKey()), "key", entry, immutableMapEntry);
            immutableMapEntry = immutableMapEntry.getNextInKeyBucket();
        }
    }

    @Override
    public Object get(@Nullable Object object) {
        return RegularImmutableMap.get(object, this.table, this.mask);
    }

    @Nullable
    static Object get(@Nullable Object object, ImmutableMapEntry[] immutableMapEntryArray, int n) {
        if (object == null) {
            return null;
        }
        int n2 = Hashing.smear(object.hashCode()) & n;
        for (ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n2]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object object2 = immutableMapEntry.getKey();
            if (!object.equals(object2)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet createEntrySet() {
        return new ImmutableMapEntrySet$RegularEntrySet(this, this.entries);
    }
}

