/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

final class TypeResolver$WildcardCapturer {
    private final AtomicInteger id = new AtomicInteger();

    private TypeResolver$WildcardCapturer() {
    }

    Type capture(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.newArrayType(this.capture(genericArrayType.getGenericComponentType()));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return Types.newParameterizedTypeWithOwner(this.captureNullable(parameterizedType.getOwnerType()), (Class)parameterizedType.getRawType(), this.capture(parameterizedType.getActualTypeArguments()));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            if (typeArray.length == 0) {
                Object[] objectArray = wildcardType.getUpperBounds();
                String string = "capture#" + this.id.incrementAndGet() + "-of ? extends " + Joiner.on('&').join(objectArray);
                return Types.newArtificialTypeVariable(TypeResolver$WildcardCapturer.class, string, wildcardType.getUpperBounds());
            }
            return type;
        }
        throw new AssertionError((Object)"must have been one of the known types");
    }

    private Type captureNullable(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        return this.capture(type);
    }

    private Type[] capture(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.capture(typeArray[i]);
        }
        return typeArray2;
    }

    /* synthetic */ TypeResolver$WildcardCapturer(TypeResolver$1 typeResolver$1) {
        this();
    }
}

