/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$AtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Cancellation;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Failure;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Listener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SafeAtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SetFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SynchronizedHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$TrustedFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$UnsafeAtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Waiter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class AbstractFuture
implements ListenableFuture {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final AbstractFuture$AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile AbstractFuture$Listener listeners;
    private volatile AbstractFuture$Waiter waiters;

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(AbstractFuture$Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == AbstractFuture$Waiter.TOMBSTONE) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected AbstractFuture() {
    }

    public Object get(long l, TimeUnit timeUnit) {
        long l2;
        Object object;
        long l3;
        block10: {
            l3 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object = this.value;
            if (object != null & !(object instanceof AbstractFuture$SetFuture)) {
                return this.getDoneValue(object);
            }
            long l4 = l2 = l3 > 0L ? System.nanoTime() + l3 : 0L;
            if (l3 >= 1000L) {
                AbstractFuture$Waiter abstractFuture$Waiter = this.waiters;
                if (abstractFuture$Waiter != AbstractFuture$Waiter.TOMBSTONE) {
                    AbstractFuture$Waiter abstractFuture$Waiter2 = new AbstractFuture$Waiter();
                    do {
                        abstractFuture$Waiter2.setNext(abstractFuture$Waiter);
                        if (!ATOMIC_HELPER.casWaiters(this, abstractFuture$Waiter, abstractFuture$Waiter2)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.removeWaiter(abstractFuture$Waiter2);
                                throw new InterruptedException();
                            }
                            object = this.value;
                            if (!(object != null & !(object instanceof AbstractFuture$SetFuture))) continue;
                            return this.getDoneValue(object);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.removeWaiter(abstractFuture$Waiter2);
                        break block10;
                    } while ((abstractFuture$Waiter = this.waiters) != AbstractFuture$Waiter.TOMBSTONE);
                }
                return this.getDoneValue(this.value);
            }
        }
        while (l3 > 0L) {
            object = this.value;
            if (object != null & !(object instanceof AbstractFuture$SetFuture)) {
                return this.getDoneValue(object);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        throw new TimeoutException();
    }

    public Object get() {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof AbstractFuture$SetFuture)) {
            return this.getDoneValue(object);
        }
        AbstractFuture$Waiter abstractFuture$Waiter = this.waiters;
        if (abstractFuture$Waiter != AbstractFuture$Waiter.TOMBSTONE) {
            AbstractFuture$Waiter abstractFuture$Waiter2 = new AbstractFuture$Waiter();
            do {
                abstractFuture$Waiter2.setNext(abstractFuture$Waiter);
                if (!ATOMIC_HELPER.casWaiters(this, abstractFuture$Waiter, abstractFuture$Waiter2)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(abstractFuture$Waiter2);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof AbstractFuture$SetFuture)));
                return this.getDoneValue(object);
            } while ((abstractFuture$Waiter = this.waiters) != AbstractFuture$Waiter.TOMBSTONE);
        }
        return this.getDoneValue(this.value);
    }

    private Object getDoneValue(Object object) {
        if (object instanceof AbstractFuture$Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((AbstractFuture$Cancellation)object).cause);
        }
        if (object instanceof AbstractFuture$Failure) {
            throw new ExecutionException(((AbstractFuture$Failure)object).exception);
        }
        if (object == NULL) {
            return null;
        }
        Object object2 = object;
        return object2;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof AbstractFuture$SetFuture);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value;
        return object instanceof AbstractFuture$Cancellation;
    }

    @Override
    public boolean cancel(boolean bl) {
        Object object = this.value;
        if (object == null | object instanceof AbstractFuture$SetFuture) {
            Throwable throwable = GENERATE_CANCELLATION_CAUSES ? this.newCancellationCause() : null;
            AbstractFuture$Cancellation abstractFuture$Cancellation = new AbstractFuture$Cancellation(bl, throwable);
            do {
                if (!ATOMIC_HELPER.casValue(this, object, abstractFuture$Cancellation)) continue;
                if (bl) {
                    this.interruptTask();
                }
                this.complete();
                if (object instanceof AbstractFuture$SetFuture) {
                    ((AbstractFuture$SetFuture)object).future.cancel(bl);
                }
                return true;
            } while ((object = this.value) instanceof AbstractFuture$SetFuture);
        }
        return false;
    }

    private Throwable newCancellationCause() {
        return new CancellationException("Future.cancel() was called.");
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof AbstractFuture$Cancellation && ((AbstractFuture$Cancellation)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        AbstractFuture$Listener abstractFuture$Listener = this.listeners;
        if (abstractFuture$Listener != AbstractFuture$Listener.TOMBSTONE) {
            AbstractFuture$Listener abstractFuture$Listener2 = new AbstractFuture$Listener(runnable, executor);
            do {
                abstractFuture$Listener2.next = abstractFuture$Listener;
                if (!ATOMIC_HELPER.casListeners(this, abstractFuture$Listener, abstractFuture$Listener2)) continue;
                return;
            } while ((abstractFuture$Listener = this.listeners) != AbstractFuture$Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    protected boolean set(@Nullable Object object) {
        Object object2;
        Object object3 = object2 = object == null ? NULL : object;
        if (ATOMIC_HELPER.casValue(this, null, object2)) {
            this.complete();
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        AbstractFuture$Failure abstractFuture$Failure = new AbstractFuture$Failure((Throwable)Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, abstractFuture$Failure)) {
            this.complete();
            return true;
        }
        return false;
    }

    private boolean completeWithFuture(ListenableFuture listenableFuture, Object object) {
        Object object2;
        if (listenableFuture instanceof AbstractFuture$TrustedFuture) {
            object2 = ((AbstractFuture)listenableFuture).value;
        } else {
            try {
                Object object3 = Uninterruptibles.getUninterruptibly(listenableFuture);
                object2 = object3 == null ? NULL : object3;
            }
            catch (ExecutionException executionException) {
                object2 = new AbstractFuture$Failure(executionException.getCause());
            }
            catch (CancellationException cancellationException) {
                object2 = new AbstractFuture$Cancellation(false, cancellationException);
            }
            catch (Throwable throwable) {
                object2 = new AbstractFuture$Failure(throwable);
            }
        }
        if (ATOMIC_HELPER.casValue(this, object, object2)) {
            this.complete();
            return true;
        }
        return false;
    }

    private void complete() {
        Object object = this.clearWaiters();
        while (object != null) {
            ((AbstractFuture$Waiter)object).unpark();
            object = ((AbstractFuture$Waiter)object).next;
        }
        object = this.clearListeners();
        Object object2 = null;
        while (object != null) {
            Object object3 = object;
            object = ((AbstractFuture$Listener)object).next;
            ((AbstractFuture$Listener)object3).next = object2;
            object2 = object3;
        }
        while (object2 != null) {
            AbstractFuture.executeListener(((AbstractFuture$Listener)object2).task, ((AbstractFuture$Listener)object2).executor);
            object2 = ((AbstractFuture$Listener)object2).next;
        }
        this.done();
    }

    void done() {
    }

    final Throwable trustedGetException() {
        return ((AbstractFuture$Failure)this.value).exception;
    }

    final void maybePropagateCancellation(@Nullable Future future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    private AbstractFuture$Waiter clearWaiters() {
        AbstractFuture$Waiter abstractFuture$Waiter;
        while (!ATOMIC_HELPER.casWaiters(this, abstractFuture$Waiter = this.waiters, AbstractFuture$Waiter.TOMBSTONE)) {
        }
        return abstractFuture$Waiter;
    }

    private AbstractFuture$Listener clearListeners() {
        AbstractFuture$Listener abstractFuture$Listener;
        while (!ATOMIC_HELPER.casListeners(this, abstractFuture$Listener = this.listeners, AbstractFuture$Listener.TOMBSTONE)) {
        }
        return abstractFuture$Listener;
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, runtimeException);
        }
    }

    static final CancellationException cancellationExceptionWithCause(@Nullable String string, @Nullable Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    static /* synthetic */ AbstractFuture$AtomicHelper access$200() {
        return ATOMIC_HELPER;
    }

    static /* synthetic */ Object access$300(AbstractFuture abstractFuture) {
        return abstractFuture.value;
    }

    static /* synthetic */ boolean access$400(AbstractFuture abstractFuture, ListenableFuture listenableFuture, Object object) {
        return abstractFuture.completeWithFuture(listenableFuture, object);
    }

    static /* synthetic */ AbstractFuture$Waiter access$600(AbstractFuture abstractFuture) {
        return abstractFuture.waiters;
    }

    static /* synthetic */ AbstractFuture$Waiter access$602(AbstractFuture abstractFuture, AbstractFuture$Waiter abstractFuture$Waiter) {
        abstractFuture.waiters = abstractFuture$Waiter;
        return abstractFuture.waiters;
    }

    static /* synthetic */ AbstractFuture$Listener access$700(AbstractFuture abstractFuture) {
        return abstractFuture.listeners;
    }

    static /* synthetic */ AbstractFuture$Listener access$702(AbstractFuture abstractFuture, AbstractFuture$Listener abstractFuture$Listener) {
        abstractFuture.listeners = abstractFuture$Listener;
        return abstractFuture.listeners;
    }

    static /* synthetic */ Object access$302(AbstractFuture abstractFuture, Object object) {
        abstractFuture.value = object;
        return abstractFuture.value;
    }

    static {
        AbstractFuture$AtomicHelper abstractFuture$AtomicHelper;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        log = Logger.getLogger(AbstractFuture.class.getName());
        try {
            abstractFuture$AtomicHelper = new AbstractFuture$UnsafeAtomicHelper(null);
        }
        catch (Throwable throwable) {
            try {
                abstractFuture$AtomicHelper = new AbstractFuture$SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(AbstractFuture$Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture$Waiter.class, AbstractFuture$Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, AbstractFuture$Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, AbstractFuture$Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Throwable throwable2) {
                log.log(Level.SEVERE, "UnsafeAtomicHelper is broken!", throwable);
                log.log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable2);
                abstractFuture$AtomicHelper = new AbstractFuture$SynchronizedHelper(null);
            }
        }
        ATOMIC_HELPER = abstractFuture$AtomicHelper;
        Class<LockSupport> clazz = LockSupport.class;
        NULL = new Object();
    }
}

