/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.ImmutableBitSet;

class SqlLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final SqlLatticeStatisticProvider INSTANCE = new SqlLatticeStatisticProvider();

    private SqlLatticeStatisticProvider() {
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        String sql = lattice.countSql(ImmutableBitSet.of(column.ordinal));
        Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, (List<String>)ImmutableList.of());
        Object[] values = (Object[])Iterables.getOnlyElement(((ScannableTable)table).scan(null));
        return ((Number)values[0]).intValue();
    }
}

