/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.Util;

public class TimestampString
implements Comparable<TimestampString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9](\\.[0-9]*[1-9])?");
    final String v;

    public TimestampString(String v) {
        this.v = v;
        Preconditions.checkArgument((boolean)PATTERN.matcher(v).matches(), (Object)v);
    }

    public TimestampString(int year, int month, int day, int h, int m, int s) {
        this(TimestampString.ymdhms(new StringBuilder(), year, month, day, h, m, s).toString());
    }

    public TimestampString withMillis(int millis) {
        Preconditions.checkArgument((millis >= 0 && millis < 1000 ? 1 : 0) != 0);
        return this.withFraction(TimestampString.pad(3, millis));
    }

    public TimestampString withNanos(int nanos) {
        Preconditions.checkArgument((nanos >= 0 && nanos < 1000000000 ? 1 : 0) != 0);
        return this.withFraction(TimestampString.pad(9, nanos));
    }

    public TimestampString withFraction(String fraction) {
        String v = this.v;
        int i = v.indexOf(46);
        if (i >= 0) {
            v = v.substring(0, i);
        }
        while (fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        if (fraction.length() > 0) {
            v = v + "." + fraction;
        }
        return new TimestampString(v);
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof TimestampString && ((TimestampString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimestampString o) {
        return this.v.compareTo(o.v);
    }

    static StringBuilder hms(StringBuilder b, int h, int m, int s) {
        TimestampString.int2(b, h);
        b.append(':');
        TimestampString.int2(b, m);
        b.append(':');
        TimestampString.int2(b, s);
        return b;
    }

    static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h, int m, int s) {
        TimestampString.ymd(b, year, month, day);
        b.append(' ');
        TimestampString.hms(b, h, m, s);
        return b;
    }

    static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        TimestampString.int4(b, year);
        b.append('-');
        TimestampString.int2(b, month);
        b.append('-');
        TimestampString.int2(b, day);
        return b;
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static TimestampString fromCalendarFields(Calendar calendar) {
        return new TimestampString(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)).withMillis(calendar.get(14));
    }

    public TimestampString round(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        int targetLength = 20 + precision;
        if (this.v.length() <= targetLength) {
            return this;
        }
        String v = this.v.substring(0, targetLength);
        while (v.length() >= 20 && (v.endsWith("0") || v.endsWith("."))) {
            v = v.substring(0, v.length() - 1);
        }
        return new TimestampString(v);
    }

    public long getMillisSinceEpoch() {
        int year = Integer.valueOf(this.v.substring(0, 4));
        int month = Integer.valueOf(this.v.substring(5, 7));
        int day = Integer.valueOf(this.v.substring(8, 10));
        int h = Integer.valueOf(this.v.substring(11, 13));
        int m = Integer.valueOf(this.v.substring(14, 16));
        int s = Integer.valueOf(this.v.substring(17, 19));
        int ms = this.getMillisInSecond();
        int d = DateTimeUtils.ymdToUnixDate((int)year, (int)month, (int)day);
        return (long)d * 86400000L + (long)h * 3600000L + (long)m * 60000L + (long)s * 1000L + (long)ms;
    }

    private int getMillisInSecond() {
        switch (this.v.length()) {
            case 19: {
                return 0;
            }
            case 21: {
                return Integer.valueOf(this.v.substring(20)) * 100;
            }
            case 22: {
                return Integer.valueOf(this.v.substring(20)) * 10;
            }
        }
        return Integer.valueOf(this.v.substring(20, 23));
    }

    public static TimestampString fromMillisSinceEpoch(long millis) {
        return new TimestampString(DateTimeUtils.unixTimestampToString((long)millis)).withMillis((int)DateTimeUtils.floorMod((long)millis, (long)1000L));
    }

    static String pad(int length, long v) {
        StringBuilder s = new StringBuilder(Long.toString(v));
        while (s.length() < length) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisSinceEpoch());
    }

    public String toString(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        int p = this.precision();
        if (precision < p) {
            return this.round(precision).toString(precision);
        }
        if (precision > p) {
            String s = this.v;
            if (p == 0) {
                s = s + ".";
            }
            return s + Strings.repeat((String)"0", (int)(precision - p));
        }
        return this.v;
    }

    private int precision() {
        return this.v.length() < 20 ? 0 : this.v.length() - 20;
    }
}

