/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.Locale;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.reduction.DateOrdinalFunction;
import org.apache.solr.analytics.function.reduction.DoubleOrdinalFunction;
import org.apache.solr.analytics.function.reduction.FloatOrdinalFunction;
import org.apache.solr.analytics.function.reduction.IntOrdinalFunction;
import org.apache.solr.analytics.function.reduction.LongOrdinalFunction;
import org.apache.solr.analytics.function.reduction.StringOrdinalFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;

public class OrdinalFunction {
    public static final String name = "ordinal";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires 2 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream percValue = params[0];
        int ord = 0;
        if (params[0] instanceof IntValue && params[0] instanceof ConstantValue) {
            ord = ((IntValue)percValue).getInt();
            if (ord == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires the ordinal to be >= 1 or <= -1, 0 is not accepted.");
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires a constant int value (the ordinal) as the first argument.");
        }
        AnalyticsValueStream param = params[1];
        if (param instanceof DateValueStream) {
            return new DateOrdinalFunction((DateValueStream)param, ord);
        }
        if (param instanceof IntValueStream) {
            return new IntOrdinalFunction((IntValueStream)param, ord);
        }
        if (param instanceof LongValueStream) {
            return new LongOrdinalFunction((LongValueStream)param, ord);
        }
        if (param instanceof FloatValueStream) {
            return new FloatOrdinalFunction((FloatValueStream)param, ord);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleOrdinalFunction((DoubleValueStream)param, ord);
        }
        if (param instanceof StringValueStream) {
            return new StringOrdinalFunction((StringValueStream)param, ord);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ordinal function requires a comparable parameter.");
    };

    protected static String createOrdinalExpressionString(AnalyticsValueStream param, double ord) {
        return String.format(Locale.ROOT, "%s(%s,%s)", name, ord, param.getExpressionStr());
    }
}

