/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.annotator;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.uima.alchemy.annotator.AbstractAlchemyAnnotator;
import org.apache.uima.alchemy.digester.DigesterProvider;
import org.apache.uima.alchemy.digester.concept.ConceptTaggingDigesterProvider;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public class URLConceptTaggingAnnotator
extends AbstractAlchemyAnnotator {
    protected DigesterProvider createDigester() {
        return new ConceptTaggingDigesterProvider();
    }

    protected URL createServiceURI() throws MalformedURLException {
        return URI.create("http://access.alchemyapi.com/calls/url/URLGetRankedConcepts").toURL();
    }

    protected String[] getServiceParameters() {
        return new String[]{"url", "maxRetrieve", "outputMode", "linkedData", "showSourceText"};
    }

    protected void initializeRuntimeParameters(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            StringBuffer serviceParamsBuf = new StringBuffer();
            serviceParamsBuf.append("&url=");
            serviceParamsBuf.append(URLEncoder.encode(aJCas.getDocumentText(), "UTF-8"));
            this.serviceParams = this.serviceParams + serviceParamsBuf.toString();
            this.serviceParams = this.serviceParams + serviceParamsBuf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

