/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.Stats;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerTaskProcessor
implements Runnable,
Closeable {
    public static final int MAX_PARALLEL_TASKS = 100;
    public static final int MAX_BLOCKED_TASKS = 1000;
    public ExecutorService tpe;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OverseerTaskQueue workQueue;
    private DistributedMap runningMap;
    private DistributedMap completedMap;
    private DistributedMap failureMap;
    private final Set<String> runningTasks;
    private final HashMap<String, OverseerTaskQueue.QueueEvent> completedTasks;
    private String myId;
    private ZkStateReader zkStateReader;
    private boolean isClosed;
    private Stats stats;
    private final Set<String> runningZKTasks;
    private final Map<String, OverseerTaskQueue.QueueEvent> blockedTasks = new LinkedHashMap<String, OverseerTaskQueue.QueueEvent>();
    private final Predicate<String> excludedTasks = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return OverseerTaskProcessor.this.runningTasks.contains(s) || OverseerTaskProcessor.this.blockedTasks.containsKey(s);
        }

        public String toString() {
            return StrUtils.join((Collection)ImmutableSet.of((Object)OverseerTaskProcessor.this.runningTasks, OverseerTaskProcessor.this.blockedTasks.keySet()), (char)',');
        }
    };
    private final Object waitLock = new Object();
    protected OverseerMessageHandlerSelector selector;
    private OverseerNodePrioritizer prioritizer;
    private final TaskBatch taskBatch = new TaskBatch();

    public OverseerTaskProcessor(ZkStateReader zkStateReader, String myId, Stats stats, OverseerMessageHandlerSelector selector, OverseerNodePrioritizer prioritizer, OverseerTaskQueue workQueue, DistributedMap runningMap, DistributedMap completedMap, DistributedMap failureMap) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.stats = stats;
        this.selector = selector;
        this.prioritizer = prioritizer;
        this.workQueue = workQueue;
        this.runningMap = runningMap;
        this.completedMap = completedMap;
        this.failureMap = failureMap;
        this.runningZKTasks = new HashSet<String>();
        this.runningTasks = new HashSet<String>();
        this.completedTasks = new HashMap();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWorkQueue() throws KeeperException, InterruptedException {
        HashMap<String, OverseerTaskQueue.QueueEvent> hashMap = this.completedTasks;
        synchronized (hashMap) {
            for (String id : this.completedTasks.keySet()) {
                this.workQueue.remove(this.completedTasks.get(id));
                this.runningZKTasks.remove(id);
            }
            this.completedTasks.clear();
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.tpe != null && !this.tpe.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.tpe);
        }
        IOUtils.closeQuietly((Closeable)this.selector);
    }

    public static List<String> getSortedOverseerNodeNames(SolrZkClient zk) throws KeeperException, InterruptedException {
        List children = null;
        try {
            children = zk.getChildren("/overseer_elect/election", null, true);
        }
        catch (Exception e) {
            log.warn("error ", (Throwable)e);
            return new ArrayList<String>();
        }
        LeaderElector.sortSeqs(children);
        ArrayList<String> nodeNames = new ArrayList<String>(children.size());
        for (String c : children) {
            nodeNames.add(LeaderElector.getNodeName(c));
        }
        return nodeNames;
    }

    public static List<String> getSortedElectionNodes(SolrZkClient zk, String path) throws KeeperException, InterruptedException {
        List children = null;
        children = zk.getChildren(path, null, true);
        LeaderElector.sortSeqs(children);
        return children;
    }

    public static String getLeaderNode(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        String id = OverseerTaskProcessor.getLeaderId(zkClient);
        return id == null ? null : LeaderElector.getNodeName(id);
    }

    public static String getLeaderId(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        byte[] data = null;
        try {
            data = zkClient.getData("/overseer_elect/leader", null, new Stat(), true);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        Map m = (Map)Utils.fromJSON((byte[])data);
        return (String)m.get("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Overseer.LeaderStatus amILeader() {
        String statsName = "collection_am_i_leader";
        Timer.Context timerContext = this.stats.time(statsName);
        boolean success = true;
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.YES;
                return leaderStatus;
            }
        }
        catch (KeeperException e) {
            success = false;
            if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                log.error("", (Throwable)e);
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.DONT_KNOW;
                return leaderStatus;
            }
            if (e.code() != KeeperException.Code.SESSIONEXPIRED) {
                log.warn("", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            success = false;
            Thread.currentThread().interrupt();
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success(statsName);
            } else {
                this.stats.error(statsName);
            }
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return Overseer.LeaderStatus.NO;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markTaskAsRunning(OverseerTaskQueue.QueueEvent head, String asyncId) throws KeeperException, InterruptedException {
        Set<String> set = this.runningZKTasks;
        synchronized (set) {
            this.runningZKTasks.add(head.getId());
        }
        set = this.runningTasks;
        synchronized (set) {
            this.runningTasks.add(head.getId());
        }
        if (asyncId != null) {
            this.runningMap.put(asyncId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTrackingMaps() {
        if (log.isDebugEnabled()) {
            Set<String> set = this.runningTasks;
            synchronized (set) {
                log.debug("RunningTasks: {}", (Object)this.runningTasks.toString());
            }
            log.debug("BlockedTasks: {}", (Object)this.blockedTasks.keySet().toString());
            set = this.completedTasks;
            synchronized (set) {
                log.debug("CompletedTasks: {}", (Object)this.completedTasks.keySet().toString());
            }
            set = this.runningZKTasks;
            synchronized (set) {
                log.debug("RunningZKTasks: {}", (Object)this.runningZKTasks.toString());
            }
        }
    }

    String getId() {
        return this.myId;
    }

    public class TaskBatch {
        private long batchId = 0L;

        public long getId() {
            return this.batchId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRunningTasks() {
            Set set = OverseerTaskProcessor.this.runningTasks;
            synchronized (set) {
                return OverseerTaskProcessor.this.runningTasks.size();
            }
        }

        static /* synthetic */ long access$208(TaskBatch x0) {
            return x0.batchId++;
        }
    }

    public static interface OverseerMessageHandlerSelector
    extends Closeable {
        public OverseerMessageHandler selectOverseerMessageHandler(ZkNodeProps var1);
    }

    protected class Runner
    implements Runnable {
        ZkNodeProps message;
        String operation;
        SolrResponse response;
        OverseerTaskQueue.QueueEvent head;
        OverseerMessageHandler messageHandler;
        private final OverseerMessageHandler.Lock lock;

        public Runner(OverseerMessageHandler messageHandler, ZkNodeProps message, String operation, OverseerTaskQueue.QueueEvent head, OverseerMessageHandler.Lock lock) {
            this.message = message;
            this.operation = operation;
            this.head = head;
            this.messageHandler = messageHandler;
            this.lock = lock;
            this.response = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String statsName = this.messageHandler.getTimerName(this.operation);
            Timer.Context timerContext = OverseerTaskProcessor.this.stats.time(statsName);
            boolean success = false;
            String asyncId = this.message.getStr("async");
            String taskKey = this.messageHandler.getTaskKey(this.message);
            try {
                try {
                    log.debug("Runner processing {}", (Object)this.head.getId());
                    this.response = this.messageHandler.processMessage(this.message, this.operation);
                }
                finally {
                    timerContext.stop();
                    this.updateStats(statsName);
                }
                if (asyncId != null) {
                    if (this.response != null && (this.response.getResponse().get("failure") != null || this.response.getResponse().get("exception") != null)) {
                        OverseerTaskProcessor.this.failureMap.put(asyncId, SolrResponse.serializable((SolrResponse)this.response));
                        log.debug("Updated failed map for task with zkid:[{}]", (Object)this.head.getId());
                    } else {
                        OverseerTaskProcessor.this.completedMap.put(asyncId, SolrResponse.serializable((SolrResponse)this.response));
                        log.debug("Updated completed map for task with zkid:[{}]", (Object)this.head.getId());
                    }
                } else {
                    this.head.setBytes(SolrResponse.serializable((SolrResponse)this.response));
                    log.debug("Completed task:[{}]", (Object)this.head.getId());
                }
                this.markTaskComplete(this.head.getId(), asyncId);
                log.debug("Marked task [{}] as completed.", (Object)this.head.getId());
                OverseerTaskProcessor.this.printTrackingMaps();
                log.debug(this.messageHandler.getName() + ": Message id:" + this.head.getId() + " complete, response:" + this.response.getResponse().toString());
                success = true;
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.resetTaskWithException(this.messageHandler, this.head.getId(), asyncId, taskKey, this.message);
                log.warn("Resetting task {} as the thread was interrupted.", (Object)this.head.getId());
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
                if (!success) {
                    this.resetTaskWithException(this.messageHandler, this.head.getId(), asyncId, taskKey, this.message);
                }
                Object e = OverseerTaskProcessor.this.waitLock;
                synchronized (e) {
                    OverseerTaskProcessor.this.waitLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markTaskComplete(String id, String asyncId) throws KeeperException, InterruptedException {
            Object object = OverseerTaskProcessor.this.completedTasks;
            synchronized (object) {
                OverseerTaskProcessor.this.completedTasks.put(id, this.head);
            }
            object = OverseerTaskProcessor.this.runningTasks;
            synchronized (object) {
                OverseerTaskProcessor.this.runningTasks.remove(id);
            }
            if (asyncId != null && !OverseerTaskProcessor.this.runningMap.remove(asyncId)) {
                log.warn("Could not find and remove async call [" + asyncId + "] from the running map.");
            }
            OverseerTaskProcessor.this.workQueue.remove(this.head);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetTaskWithException(OverseerMessageHandler messageHandler, String id, String asyncId, String taskKey, ZkNodeProps message) {
            log.warn("Resetting task: {}, requestid: {}, taskKey: {}", new Object[]{id, asyncId, taskKey});
            try {
                if (asyncId != null && !OverseerTaskProcessor.this.runningMap.remove(asyncId)) {
                    log.warn("Could not find and remove async call [" + asyncId + "] from the running map.");
                }
                Set set = OverseerTaskProcessor.this.runningTasks;
                synchronized (set) {
                    OverseerTaskProcessor.this.runningTasks.remove(id);
                }
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void updateStats(String statsName) {
            if (this.isSuccessful()) {
                OverseerTaskProcessor.this.stats.success(statsName);
            } else {
                OverseerTaskProcessor.this.stats.error(statsName);
                OverseerTaskProcessor.this.stats.storeFailureDetails(statsName, this.message, this.response);
            }
        }

        private boolean isSuccessful() {
            if (this.response == null) {
                return false;
            }
            return this.response.getResponse().get("failure") == null && this.response.getResponse().get("exception") == null;
        }
    }
}

