/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.DateStatsValues;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;

public class SortedDateStatsValues
implements StatsValues {
    private final DateStatsValues dsv;
    private final String fieldName;
    private SortedNumericDocValues sndv;

    public SortedDateStatsValues(DateStatsValues dsv, StatsField field) {
        this.dsv = dsv;
        this.fieldName = field.getSchemaField().getName();
    }

    @Override
    public void accumulate(NamedList stv) {
        this.dsv.accumulate(stv);
    }

    @Override
    public void accumulate(int docId) throws IOException {
        if (!this.sndv.advanceExact(docId)) {
            this.missing();
        } else {
            for (int i = 0; i < this.sndv.docValueCount(); ++i) {
                this.dsv.accumulate(new Date(this.sndv.nextValue()), 1);
            }
        }
    }

    @Override
    public void accumulate(BytesRef value, int count) {
        this.dsv.accumulate(value, count);
    }

    @Override
    public void missing() {
        this.dsv.missing();
    }

    @Override
    public void addMissing(int count) {
        this.dsv.addMissing(count);
    }

    @Override
    public void addFacet(String facetName, Map<String, StatsValues> facetValues) {
        this.dsv.addFacet(facetName, facetValues);
    }

    @Override
    public NamedList<?> getStatsValues() {
        return this.dsv.getStatsValues();
    }

    @Override
    public void setNextReader(LeafReaderContext ctx) throws IOException {
        this.sndv = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.fieldName);
        assert (this.sndv != null);
    }
}

