/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.join.GraphEdgeCollector;
import org.apache.solr.search.join.GraphPointsCollector;
import org.apache.solr.search.join.GraphTermsCollector;

public class GraphQuery
extends Query {
    private Query q;
    private String fromField;
    private String toField;
    private Query traversalFilter;
    private int maxDepth = -1;
    private boolean useAutn = true;
    private boolean onlyLeafNodes = false;
    private boolean returnRoot = true;

    public GraphQuery(Query q, String fromField, String toField) {
        this(q, fromField, toField, null);
    }

    public GraphQuery(Query q, String fromField, String toField, Query traversalFilter) {
        this.q = q;
        this.fromField = fromField;
        this.toField = toField;
        this.traversalFilter = traversalFilter;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        GraphQueryWeight graphWeight = new GraphQueryWeight((SolrIndexSearcher)searcher, boost);
        return graphWeight;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("[[" + this.q.toString() + "]," + this.fromField + "=" + this.toField + "]");
        if (this.traversalFilter != null) {
            sb.append(" [TraversalFilter: " + this.traversalFilter.toString() + "]");
        }
        sb.append("[maxDepth=" + this.maxDepth + "]");
        sb.append("[returnRoot=" + this.returnRoot + "]");
        sb.append("[onlyLeafNodes=" + this.onlyLeafNodes + "]");
        sb.append("[useAutn=" + this.useAutn + "]");
        return sb.toString();
    }

    public Query getTraversalFilter() {
        return this.traversalFilter;
    }

    public void setTraversalFilter(Query traversalFilter) {
        this.traversalFilter = traversalFilter;
    }

    public Query getQ() {
        return this.q;
    }

    public void setQ(Query q) {
        this.q = q;
    }

    public String getFromField() {
        return this.fromField;
    }

    public void setFromField(String fromField) {
        this.fromField = fromField;
    }

    public String getToField() {
        return this.toField;
    }

    public void setToField(String toField) {
        this.toField = toField;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isUseAutn() {
        return this.useAutn;
    }

    public void setUseAutn(boolean useAutn) {
        this.useAutn = useAutn;
    }

    public boolean isOnlyLeafNodes() {
        return this.onlyLeafNodes;
    }

    public void setOnlyLeafNodes(boolean onlyLeafNodes) {
        this.onlyLeafNodes = onlyLeafNodes;
    }

    public boolean isReturnRoot() {
        return this.returnRoot;
    }

    public void setReturnRoot(boolean returnRoot) {
        this.returnRoot = returnRoot;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.fromField);
        result = 31 * result + this.maxDepth;
        result = 31 * result + (this.onlyLeafNodes ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.q);
        result = 31 * result + (this.returnRoot ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.toField);
        result = 31 * result + Objects.hashCode(this.traversalFilter);
        result = 31 * result + (this.useAutn ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GraphQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(GraphQuery other) {
        return Objects.equals(this.fromField, other.fromField) && this.maxDepth == other.maxDepth && this.onlyLeafNodes == other.onlyLeafNodes && this.returnRoot == other.returnRoot && this.useAutn == other.useAutn && Objects.equals(this.q, other.q) && Objects.equals(this.toField, other.toField) && Objects.equals(this.traversalFilter, other.traversalFilter);
    }

    private static class GraphScorer
    extends Scorer {
        final DocIdSetIterator iter;
        final float score;

        public GraphScorer(Weight w, DocIdSetIterator iter, float score) throws IOException {
            super(w);
            this.iter = iter == null ? DocIdSet.EMPTY.iterator() : iter;
            this.score = score;
        }

        public float score() throws IOException {
            return this.score;
        }

        public DocIdSetIterator iterator() {
            return this.iter;
        }

        public int docID() {
            return this.iter.docID();
        }
    }

    protected class GraphQueryWeight
    extends Weight {
        final SolrIndexSearcher fromSearcher;
        private int currentDepth;
        private Filter filter;
        private DocSet resultSet;
        SchemaField collectSchemaField;
        SchemaField matchSchemaField;

        public GraphQueryWeight(SolrIndexSearcher searcher, float boost) {
            super(null);
            this.currentDepth = -1;
            this.fromSearcher = searcher;
            this.matchSchemaField = searcher.getSchema().getField(GraphQuery.this.fromField);
            this.collectSchemaField = searcher.getSchema().getField(GraphQuery.this.toField);
        }

        GraphQuery getGraphQuery() {
            return GraphQuery.this;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean exists;
            Scorer cs = this.scorer(context);
            boolean bl = exists = cs != null && cs.iterator().advance(doc) == doc;
            if (exists) {
                ArrayList subs = new ArrayList();
                return Explanation.match((float)1.0f, (String)"Graph Match", subs);
            }
            ArrayList subs = new ArrayList();
            return Explanation.noMatch((String)"No Graph Match.", subs);
        }

        private DocSet getDocSet() throws IOException {
            int capacity = this.fromSearcher.getRawReader().maxDoc();
            FixedBitSet resultBits = new FixedBitSet(capacity);
            BitDocSet fromSet = null;
            FixedBitSet rootBits = null;
            Query frontierQuery = GraphQuery.this.q;
            DocSet leafNodes = this.resolveLeafNodes();
            do {
                ++this.currentDepth;
                if (GraphQuery.this.maxDepth != -1 && this.currentDepth >= GraphQuery.this.maxDepth) {
                    fromSet = this.fromSearcher.getDocSetBits(frontierQuery);
                    frontierQuery = null;
                } else {
                    GraphEdgeCollector graphResultCollector = this.collectSchemaField.getType().isPointField() ? new GraphPointsCollector(this.collectSchemaField, new BitDocSet(resultBits), leafNodes) : new GraphTermsCollector(this.collectSchemaField, new BitDocSet(resultBits), leafNodes);
                    fromSet = new BitDocSet(new FixedBitSet(capacity));
                    graphResultCollector.setCollectDocs(fromSet.getBits());
                    this.fromSearcher.search(frontierQuery, graphResultCollector);
                    frontierQuery = graphResultCollector.getResultQuery(this.matchSchemaField, GraphQuery.this.isUseAutn());
                    if (frontierQuery != null && GraphQuery.this.getTraversalFilter() != null) {
                        BooleanQuery.Builder builder = new BooleanQuery.Builder();
                        builder.add(frontierQuery, BooleanClause.Occur.MUST);
                        builder.add(GraphQuery.this.getTraversalFilter(), BooleanClause.Occur.MUST);
                        frontierQuery = builder.build();
                    }
                }
                if (this.currentDepth == 0 && !GraphQuery.this.returnRoot) {
                    rootBits = fromSet.getBits();
                }
                resultBits.or(fromSet.getBits());
            } while ((GraphQuery.this.maxDepth == -1 || this.currentDepth < GraphQuery.this.maxDepth) && frontierQuery != null);
            if (!GraphQuery.this.returnRoot) {
                resultBits.andNot(rootBits);
            }
            BitDocSet resultSet = new BitDocSet(resultBits);
            if (GraphQuery.this.onlyLeafNodes) {
                return resultSet.intersection(leafNodes);
            }
            return resultSet;
        }

        private DocSet resolveLeafNodes() throws IOException {
            String field = this.collectSchemaField.getName();
            BooleanQuery.Builder leafNodeQuery = new BooleanQuery.Builder();
            DocValuesFieldExistsQuery edgeQuery = this.collectSchemaField.hasDocValues() ? new DocValuesFieldExistsQuery(field) : new WildcardQuery(new Term(field, "*"));
            leafNodeQuery.add((Query)edgeQuery, BooleanClause.Occur.MUST_NOT);
            DocSet leafNodes = this.fromSearcher.getDocSet((Query)leafNodeQuery.build());
            return leafNodes;
        }

        private Automaton buildAutomaton(BytesRefHash termBytesHash) {
            TreeSet<BytesRef> terms = new TreeSet<BytesRef>();
            for (int i = 0; i < termBytesHash.size(); ++i) {
                BytesRef ref = new BytesRef();
                termBytesHash.get(i, ref);
                terms.add(ref);
            }
            Automaton a = DaciukMihovAutomatonBuilder.build(terms);
            return a;
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet readerSet;
            if (this.filter == null) {
                this.resultSet = this.getDocSet();
                this.filter = this.resultSet.getTopFilter();
            }
            return new GraphScorer(this, (readerSet = this.filter.getDocIdSet(context, context.reader().getLiveDocs())) == null ? DocIdSetIterator.empty() : readerSet.iterator(), 1.0f);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        public void extractTerms(Set<Term> terms) {
        }
    }
}

