/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MethodMetric;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableRates;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.metrics2.lib.MutableStat;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MutableMetricsFactory {
    private static final Log LOG = LogFactory.getLog(MutableMetricsFactory.class);

    MutableMetric newForField(Field field, Metric annotation, MetricsRegistry registry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("field " + field + " with annotation " + annotation));
        }
        MetricsInfo info = this.getInfo(annotation, field);
        MutableMetric metric = this.newForField(field, annotation);
        if (metric != null) {
            registry.add(info.name(), metric);
            return metric;
        }
        Class<?> cls = field.getType();
        if (cls == MutableCounterInt.class) {
            return registry.newCounter(info, 0);
        }
        if (cls == MutableCounterLong.class) {
            return registry.newCounter(info, 0L);
        }
        if (cls == MutableGaugeInt.class) {
            return registry.newGauge(info, 0);
        }
        if (cls == MutableGaugeLong.class) {
            return registry.newGauge(info, 0L);
        }
        if (cls == MutableRate.class) {
            return registry.newRate(info.name(), info.description(), annotation.always());
        }
        if (cls == MutableRates.class) {
            return new MutableRates(registry);
        }
        if (cls == MutableRatesWithAggregation.class) {
            return registry.newRatesWithAggregation(info.name());
        }
        if (cls == MutableStat.class) {
            return registry.newStat(info.name(), info.description(), annotation.sampleName(), annotation.valueName(), annotation.always());
        }
        throw new MetricsException("Unsupported metric field " + field.getName() + " of type " + field.getType().getName());
    }

    MutableMetric newForMethod(Object source, Method method, Metric annotation, MetricsRegistry registry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("method " + method + " with annotation " + annotation));
        }
        MetricsInfo info = this.getInfo(annotation, method);
        MutableMetric metric = this.newForMethod(source, method, annotation);
        metric = metric != null ? metric : new MethodMetric(source, method, info, annotation.type());
        registry.add(info.name(), metric);
        return metric;
    }

    protected MutableMetric newForField(Field field, Metric annotation) {
        return null;
    }

    protected MutableMetric newForMethod(Object source, Method method, Metric annotation) {
        return null;
    }

    protected MetricsInfo getInfo(Metric annotation, Field field) {
        return this.getInfo(annotation, this.getName(field));
    }

    protected String getName(Field field) {
        return StringUtils.capitalize((String)field.getName());
    }

    protected MetricsInfo getInfo(Metric annotation, Method method) {
        return this.getInfo(annotation, this.getName(method));
    }

    protected MetricsInfo getInfo(Class<?> cls, Metrics annotation) {
        String name = annotation.name();
        String about = annotation.about();
        String name2 = name.isEmpty() ? cls.getSimpleName() : name;
        return Interns.info(name2, about.isEmpty() ? name2 : about);
    }

    protected String getName(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return StringUtils.capitalize((String)methodName.substring(3));
        }
        return StringUtils.capitalize((String)methodName);
    }

    protected MetricsInfo getInfo(Metric annotation, String defaultName) {
        String[] value = annotation.value();
        if (value.length == 2) {
            return Interns.info(value[0], value[1]);
        }
        if (value.length == 1) {
            return Interns.info(defaultName, value[0]);
        }
        return Interns.info(defaultName, defaultName);
    }
}

