/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.CookieSetting;
import org.restlet.data.Digest;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.engine.header.CacheDirectiveReader;
import org.restlet.engine.header.CacheDirectiveWriter;
import org.restlet.engine.header.ContentType;
import org.restlet.engine.header.CookieSettingReader;
import org.restlet.engine.header.CookieSettingWriter;
import org.restlet.engine.header.CookieWriter;
import org.restlet.engine.header.DateWriter;
import org.restlet.engine.header.DimensionReader;
import org.restlet.engine.header.DimensionWriter;
import org.restlet.engine.header.DispositionReader;
import org.restlet.engine.header.DispositionWriter;
import org.restlet.engine.header.EncodingReader;
import org.restlet.engine.header.EncodingWriter;
import org.restlet.engine.header.ExpectationWriter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.LanguageReader;
import org.restlet.engine.header.LanguageWriter;
import org.restlet.engine.header.MethodReader;
import org.restlet.engine.header.MethodWriter;
import org.restlet.engine.header.PreferenceWriter;
import org.restlet.engine.header.RangeReader;
import org.restlet.engine.header.RangeWriter;
import org.restlet.engine.header.RecipientInfoReader;
import org.restlet.engine.header.RecipientInfoWriter;
import org.restlet.engine.header.StringReader;
import org.restlet.engine.header.StringWriter;
import org.restlet.engine.header.TagWriter;
import org.restlet.engine.header.TokenReader;
import org.restlet.engine.header.WarningReader;
import org.restlet.engine.header.WarningWriter;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.CaseInsensitiveHashSet;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class HeaderUtils {
    private static final Set<String> STANDARD_HEADERS = Collections.unmodifiableSet(new CaseInsensitiveHashSet((Collection<? extends String>)Arrays.asList("Access-Control-Allow-Credential", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Patch", "Accept-Ranges", "Age", "Allow", "Authentication-Info", "Authorization", "Cache-Control", "Connection", "Content-Disposition", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Cookie", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "Set-Cookie", "Set-Cookie2", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate")));
    private static final Set<String> UNSUPPORTED_STANDARD_HEADERS = Collections.unmodifiableSet(new CaseInsensitiveHashSet((Collection<? extends String>)Arrays.asList("Pragma", "Trailer", "Transfer-Encoding", "TE", "Upgrade")));

    public static void addEntityHeaders(Representation entity, Series<Header> headers) {
        if (entity == null || !entity.isAvailable()) {
            HeaderUtils.addHeader("Content-Length", "0", headers);
        } else if (entity.getAvailableSize() != -1L) {
            HeaderUtils.addHeader("Content-Length", Long.toString(entity.getAvailableSize()), headers);
        }
        if (entity != null) {
            HeaderUtils.addHeader("Content-Encoding", EncodingWriter.write(entity.getEncodings()), headers);
            HeaderUtils.addHeader("Content-Language", LanguageWriter.write(entity.getLanguages()), headers);
            if (entity.getLocationRef() != null) {
                HeaderUtils.addHeader("Content-Location", entity.getLocationRef().getTargetRef().toString(), headers);
            }
            if (entity.getDigest() != null && "MD5".equals(entity.getDigest().getAlgorithm())) {
                HeaderUtils.addHeader("Content-MD5", new String(Base64.encode(entity.getDigest().getValue(), false)), headers);
            }
            if (entity.getRange() != null) {
                HeaderUtils.addHeader("Content-Range", RangeWriter.write(entity.getRange(), entity.getSize()), headers);
            }
            if (entity.getMediaType() != null) {
                HeaderUtils.addHeader("Content-Type", ContentType.writeHeader(entity), headers);
            }
            if (entity.getExpirationDate() != null) {
                HeaderUtils.addHeader("Expires", DateWriter.write(entity.getExpirationDate()), headers);
            }
            if (entity.getModificationDate() != null) {
                HeaderUtils.addHeader("Last-Modified", DateWriter.write(entity.getModificationDate()), headers);
            }
            if (entity.getTag() != null) {
                HeaderUtils.addHeader("ETag", TagWriter.write(entity.getTag()), headers);
            }
            if (entity.getDisposition() != null && !"none".equals(entity.getDisposition().getType())) {
                HeaderUtils.addHeader("Content-Disposition", DispositionWriter.write(entity.getDisposition()), headers);
            }
        }
    }

    public static void addExtensionHeaders(Series<Header> existingHeaders, Series<Header> additionalHeaders) {
        if (additionalHeaders != null) {
            for (Header param : additionalHeaders) {
                if (STANDARD_HEADERS.contains(param.getName())) {
                    Context.getCurrentLogger().warning("Addition of the standard header \"" + param.getName() + "\" is not allowed. Please use the equivalent property in the Restlet API.");
                    continue;
                }
                if (UNSUPPORTED_STANDARD_HEADERS.contains(param.getName())) {
                    Context.getCurrentLogger().warning("Addition of the standard header \"" + param.getName() + "\" is discouraged as a future version of the Restlet API will directly support it.");
                    existingHeaders.add(param);
                    continue;
                }
                existingHeaders.add(param);
            }
        }
    }

    public static void addGeneralHeaders(Message message, Series<Header> headers) {
        HeaderUtils.addHeader("Cache-Control", CacheDirectiveWriter.write(message.getCacheDirectives()), headers);
        if (message.getDate() == null) {
            message.setDate(new Date());
        }
        HeaderUtils.addHeader("Date", DateWriter.write(message.getDate()), headers);
        HeaderUtils.addHeader("Via", RecipientInfoWriter.write(message.getRecipientsInfo()), headers);
        HeaderUtils.addHeader("Warning", WarningWriter.write(message.getWarnings()), headers);
    }

    public static void addHeader(String headerName, String headerValue, Series<Header> headers) {
        if (headerName != null && headerValue != null && headerValue.length() > 0) {
            try {
                headers.add(headerName, headerValue);
            }
            catch (Throwable t) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to format the " + headerName + " header", t);
            }
        }
    }

    public static void addNotModifiedEntityHeaders(Representation entity, Series<Header> headers) {
        if (entity != null) {
            if (entity.getTag() != null) {
                HeaderUtils.addHeader("ETag", TagWriter.write(entity.getTag()), headers);
            }
            if (entity.getLocationRef() != null) {
                HeaderUtils.addHeader("Content-Location", entity.getLocationRef().getTargetRef().toString(), headers);
            }
        }
    }

    public static void addRequestHeaders(Request request, Series<Header> headers) {
        String authHeader;
        ChallengeResponse proxyChallengeResponse;
        String authHeader2;
        Reference hostRef;
        ClientInfo clientInfo = request.getClientInfo();
        if (!clientInfo.getAcceptedMediaTypes().isEmpty()) {
            HeaderUtils.addHeader("Accept", PreferenceWriter.write(clientInfo.getAcceptedMediaTypes()), headers);
        } else {
            HeaderUtils.addHeader("Accept", MediaType.ALL.getName(), headers);
        }
        if (!clientInfo.getAcceptedCharacterSets().isEmpty()) {
            HeaderUtils.addHeader("Accept-Charset", PreferenceWriter.write(clientInfo.getAcceptedCharacterSets()), headers);
        }
        if (!clientInfo.getAcceptedEncodings().isEmpty()) {
            HeaderUtils.addHeader("Accept-Encoding", PreferenceWriter.write(clientInfo.getAcceptedEncodings()), headers);
        }
        if (!clientInfo.getAcceptedLanguages().isEmpty()) {
            HeaderUtils.addHeader("Accept-Language", PreferenceWriter.write(clientInfo.getAcceptedLanguages()), headers);
        }
        if (!clientInfo.getAcceptedPatches().isEmpty()) {
            HeaderUtils.addHeader("Accept-Patch", PreferenceWriter.write(clientInfo.getAcceptedPatches()), headers);
        }
        if (!clientInfo.getExpectations().isEmpty()) {
            HeaderUtils.addHeader("Expect", ExpectationWriter.write(clientInfo.getExpectations()), headers);
        }
        if (clientInfo.getFrom() != null) {
            HeaderUtils.addHeader("From", request.getClientInfo().getFrom(), headers);
        }
        Reference reference = hostRef = request.getResourceRef().getBaseRef() != null ? request.getResourceRef().getBaseRef() : request.getResourceRef();
        if (hostRef.getHostDomain() != null) {
            String host = hostRef.getHostDomain();
            int hostRefPortValue = hostRef.getHostPort();
            if (hostRefPortValue != -1 && hostRefPortValue != request.getProtocol().getDefaultPort()) {
                host = host + ':' + hostRefPortValue;
            }
            HeaderUtils.addHeader("Host", host, headers);
        }
        Conditions conditions = request.getConditions();
        HeaderUtils.addHeader("If-Match", TagWriter.write(conditions.getMatch()), headers);
        HeaderUtils.addHeader("If-None-Match", TagWriter.write(conditions.getNoneMatch()), headers);
        if (conditions.getModifiedSince() != null) {
            HeaderUtils.addHeader("If-Modified-Since", DateWriter.write(conditions.getModifiedSince()), headers);
        }
        if (conditions.getRangeTag() != null && conditions.getRangeDate() != null) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP If-Range header due to the presence of both entity tag and modification date.");
        } else if (conditions.getRangeTag() != null) {
            HeaderUtils.addHeader("If-Range", TagWriter.write(conditions.getRangeTag()), headers);
        } else if (conditions.getRangeDate() != null) {
            HeaderUtils.addHeader("If-Range", DateWriter.write(conditions.getRangeDate()), headers);
        }
        if (conditions.getUnmodifiedSince() != null) {
            HeaderUtils.addHeader("If-Unmodified-Since", DateWriter.write(conditions.getUnmodifiedSince()), headers);
        }
        if (request.getMaxForwards() > -1) {
            HeaderUtils.addHeader("Max-Forwards", Integer.toString(request.getMaxForwards()), headers);
        }
        if (!request.getRanges().isEmpty()) {
            HeaderUtils.addHeader("Range", RangeWriter.write(request.getRanges()), headers);
        }
        if (request.getReferrerRef() != null) {
            HeaderUtils.addHeader("Referer", request.getReferrerRef().toString(), headers);
        }
        if (request.getClientInfo().getAgent() != null) {
            HeaderUtils.addHeader("User-Agent", request.getClientInfo().getAgent(), headers);
        } else {
            HeaderUtils.addHeader("User-Agent", "Restlet-Framework/2.3.0", headers);
        }
        if (clientInfo.getExpectations().size() > 0) {
            HeaderUtils.addHeader("Accept-Encoding", PreferenceWriter.write(clientInfo.getAcceptedEncodings()), headers);
        }
        if (request.getAccessControlRequestHeaders() != null) {
            HeaderUtils.addHeader("Access-Control-Request-Headers", StringWriter.write(request.getAccessControlRequestHeaders()), headers);
        }
        if (request.getAccessControlRequestMethod() != null) {
            HeaderUtils.addHeader("Access-Control-Request-Method", request.getAccessControlRequestMethod().getName(), headers);
        }
        if (request.getCookies().size() > 0) {
            HeaderUtils.addHeader("Cookie", CookieWriter.write(request.getCookies()), headers);
        }
        Series additionalHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
        HeaderUtils.addExtensionHeaders(headers, additionalHeaders);
        ChallengeResponse challengeResponse = request.getChallengeResponse();
        if (challengeResponse != null && (authHeader2 = AuthenticatorUtils.formatResponse(challengeResponse, request, headers)) != null) {
            HeaderUtils.addHeader("Authorization", authHeader2, headers);
        }
        if ((proxyChallengeResponse = request.getProxyChallengeResponse()) != null && (authHeader = AuthenticatorUtils.formatResponse(proxyChallengeResponse, request, headers)) != null) {
            HeaderUtils.addHeader("Proxy-Authorization", authHeader, headers);
        }
    }

    public static void addResponseHeaders(Response response, Series<Header> headers) {
        if (response.getServerInfo().isAcceptingRanges()) {
            HeaderUtils.addHeader("Accept-Ranges", "bytes", headers);
        }
        if (response.getAge() > 0) {
            HeaderUtils.addHeader("Age", Integer.toString(response.getAge()), headers);
        }
        if (response.getStatus().equals(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED) || Method.OPTIONS.equals(response.getRequest().getMethod())) {
            HeaderUtils.addHeader("Allow", MethodWriter.write(response.getAllowedMethods()), headers);
        }
        if (response.getLocationRef() != null) {
            HeaderUtils.addHeader("Location", response.getLocationRef().getTargetRef().toString(), headers);
        }
        if (response.getProxyChallengeRequests() != null) {
            for (ChallengeRequest challengeRequest : response.getProxyChallengeRequests()) {
                HeaderUtils.addHeader("Proxy-Authenticate", AuthenticatorUtils.formatRequest(challengeRequest, response, headers), headers);
            }
        }
        if (response.getRetryAfter() != null) {
            HeaderUtils.addHeader("Retry-After", DateWriter.write(response.getRetryAfter()), headers);
        }
        if (response.getServerInfo() != null && response.getServerInfo().getAgent() != null) {
            HeaderUtils.addHeader("Server", response.getServerInfo().getAgent(), headers);
        } else {
            HeaderUtils.addHeader("Server", "Restlet-Framework/2.3.0", headers);
        }
        if (response.getRequest().getClientInfo().getAgent() == null || !response.getRequest().getClientInfo().getAgent().contains("MSIE")) {
            HeaderUtils.addHeader("Vary", DimensionWriter.write(response.getDimensions()), headers);
        }
        if (response.getChallengeRequests() != null) {
            for (ChallengeRequest challengeRequest : response.getChallengeRequests()) {
                HeaderUtils.addHeader("WWW-Authenticate", AuthenticatorUtils.formatRequest(challengeRequest, response, headers), headers);
            }
        }
        if (response.getAccessControlAllowCredential() != null) {
            HeaderUtils.addHeader("Access-Control-Allow-Credential", response.getAccessControlAllowCredential().toString(), headers);
        }
        if (response.getAccessControlAllowHeaders() != null) {
            HeaderUtils.addHeader("Access-Control-Allow-Headers", StringWriter.write(response.getAccessControlAllowHeaders()), headers);
        }
        if (response.getAccessControlAllowOrigin() != null) {
            HeaderUtils.addHeader("Access-Control-Allow-Origin", response.getAccessControlAllowOrigin(), headers);
        }
        if (response.getAccessControlAllowMethods() != null) {
            HeaderUtils.addHeader("Access-Control-Allow-Methods", MethodWriter.write(response.getAccessControlAllowMethods()), headers);
        }
        if (response.getAuthenticationInfo() != null) {
            HeaderUtils.addHeader("Authentication-Info", AuthenticatorUtils.formatAuthenticationInfo(response.getAuthenticationInfo()), headers);
        }
        for (CookieSetting cookieSetting : response.getCookieSettings()) {
            HeaderUtils.addHeader("Set-Cookie", CookieSettingWriter.write(cookieSetting), headers);
        }
        Series additionalHeaders = (Series)response.getAttributes().get("org.restlet.http.headers");
        HeaderUtils.addExtensionHeaders(headers, additionalHeaders);
    }

    public static void copyExtensionHeaders(Series<Header> headers, Response response) {
        if (headers != null) {
            Series<Header> extensionHeaders = (Series<Header>)response.getAttributes().get("org.restlet.http.headers");
            if (extensionHeaders == null) {
                extensionHeaders = new Series<Header>(Header.class);
                response.getAttributes().put("org.restlet.http.headers", extensionHeaders);
            }
            for (Header header : headers) {
                if (STANDARD_HEADERS.contains(header.getName())) continue;
                extensionHeaders.add(header);
            }
        }
    }

    public static void copyResponseTransportHeaders(Series<Header> headers, Response response) {
        if (headers != null) {
            for (Header header : headers) {
                List<ChallengeRequest> crs;
                if (header.getName().equalsIgnoreCase("Location")) {
                    response.setLocationRef(header.getValue());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Age")) {
                    try {
                        response.setAge(Integer.parseInt(header.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during Age header parsing. Header: " + header.getValue(), nfe);
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Date")) {
                    Date date = DateUtils.parse(header.getValue());
                    if (date == null) {
                        date = new Date();
                    }
                    response.setDate(date);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Retry-After")) {
                    Date retryAfter = DateUtils.parse(header.getValue());
                    if (retryAfter == null) {
                        try {
                            int retryAfterSecs = Integer.parseInt(header.getValue());
                            Calendar calendar = Calendar.getInstance();
                            calendar.add(13, retryAfterSecs);
                            retryAfter = calendar.getTime();
                        }
                        catch (NumberFormatException nfe) {
                            Context.getCurrentLogger().log(Level.WARNING, "Error during Retry-After header parsing. Header: " + header.getValue(), nfe);
                        }
                    }
                    response.setRetryAfter(retryAfter);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                    try {
                        CookieSettingReader cr = new CookieSettingReader(header.getValue());
                        response.getCookieSettings().add(cr.readValue());
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during cookie setting parsing. Header: " + header.getValue(), e);
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("WWW-Authenticate")) {
                    crs = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                    response.getChallengeRequests().addAll(crs);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Proxy-Authenticate")) {
                    crs = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                    response.getProxyChallengeRequests().addAll(crs);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Authentication-Info")) {
                    AuthenticationInfo authenticationInfo = AuthenticatorUtils.parseAuthenticationInfo(header.getValue());
                    response.setAuthenticationInfo(authenticationInfo);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Server")) {
                    response.getServerInfo().setAgent(header.getValue());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Allow")) {
                    MethodReader.addValues(header, response.getAllowedMethods());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Vary")) {
                    DimensionReader.addValues(header, response.getDimensions());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Via")) {
                    RecipientInfoReader.addValues(header, response.getRecipientsInfo());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Warning")) {
                    WarningReader.addValues(header, response.getWarnings());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Cache-Control")) {
                    CacheDirectiveReader.addValues(header, response.getCacheDirectives());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Accept-Ranges")) {
                    TokenReader tr = new TokenReader(header.getValue());
                    response.getServerInfo().setAcceptingRanges(tr.readValues().contains("bytes"));
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Access-Control-Allow-Credential")) {
                    response.setAccessControlAllowCredential(Boolean.parseBoolean(header.getValue()));
                    StringReader.addValues(header, response.getAccessControlAllowHeaders());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Access-Control-Allow-Origin")) {
                    response.setAccessControlAllowOrigin(header.getValue());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Access-Control-Allow-Methods")) {
                    MethodReader.addValues(header, response.getAccessControlAllowMethods());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Access-Control-Expose-Headers")) continue;
                StringReader.addValues(header, response.getAccessControlExposeHeaders());
            }
        }
    }

    public static Representation extractEntityHeaders(Iterable<Header> headers, Representation representation) throws NumberFormatException {
        Representation result = representation == null ? new EmptyRepresentation() : representation;
        boolean entityHeaderFound = false;
        if (headers != null) {
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    ContentType contentType = new ContentType(header.getValue());
                    result.setMediaType(contentType.getMediaType());
                    if (result.getCharacterSet() == null || contentType.getCharacterSet() != null) {
                        result.setCharacterSet(contentType.getCharacterSet());
                    }
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Length")) {
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Expires")) {
                    result.setExpirationDate(HeaderReader.readDate(header.getValue(), false));
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                    new EncodingReader(header.getValue()).addValues(result.getEncodings());
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Language")) {
                    new LanguageReader(header.getValue()).addValues(result.getLanguages());
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Last-Modified")) {
                    result.setModificationDate(HeaderReader.readDate(header.getValue(), false));
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("ETag")) {
                    result.setTag(Tag.parse(header.getValue()));
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Location")) {
                    result.setLocationRef(header.getValue());
                    entityHeaderFound = true;
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Disposition")) {
                    try {
                        result.setDisposition(new DispositionReader(header.getValue()).readValue());
                        entityHeaderFound = true;
                    }
                    catch (IOException ioe) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during Content-Disposition header parsing. Header: " + header.getValue(), ioe);
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Range")) {
                    RangeReader.update(header.getValue(), result);
                    entityHeaderFound = true;
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-MD5")) continue;
                String base64hash = header.getValue();
                if (base64hash.length() == 22) {
                    base64hash = base64hash + "==";
                }
                result.setDigest(new Digest("MD5", Base64.decode(base64hash)));
                entityHeaderFound = true;
            }
        }
        if (representation == null && !entityHeaderFound) {
            result = null;
        }
        return result;
    }

    public static long getContentLength(Series<Header> headers) {
        long contentLength = -1L;
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getName().equalsIgnoreCase("Content-Length")) continue;
                try {
                    contentLength = Long.parseLong(header.getValue());
                }
                catch (NumberFormatException e) {
                    contentLength = -1L;
                }
            }
        }
        return contentLength;
    }

    public static boolean isAlpha(int character) {
        return HeaderUtils.isUpperCase(character) || HeaderUtils.isLowerCase(character);
    }

    public static boolean isAsciiChar(int character) {
        return character >= 0 && character <= 127;
    }

    public static boolean isCarriageReturn(int character) {
        return character == 13;
    }

    public static boolean isChunkedEncoding(Series<Header> headers) {
        boolean result = false;
        if (headers != null) {
            String header = headers.getFirstValue("Transfer-Encoding", true);
            result = "chunked".equalsIgnoreCase(header);
        }
        return result;
    }

    public static boolean isComma(int character) {
        return character == 44;
    }

    public static boolean isCommentText(int character) {
        return HeaderUtils.isText(character) && character != 40 && character != 41;
    }

    public static boolean isConnectionClose(Series<Header> headers) {
        boolean result = false;
        if (headers != null) {
            String header = headers.getFirstValue("Connection", true);
            result = "close".equalsIgnoreCase(header);
        }
        return result;
    }

    public static boolean isControlChar(int character) {
        return character >= 0 && character <= 31 || character == 127;
    }

    public static boolean isDigit(int character) {
        return character >= 48 && character <= 57;
    }

    public static boolean isDoubleQuote(int character) {
        return character == 34;
    }

    public static boolean isHorizontalTab(int character) {
        return character == 9;
    }

    public static boolean isLatin1Char(int character) {
        return character >= 0 && character <= 255;
    }

    public static boolean isLinearWhiteSpace(int character) {
        return HeaderUtils.isCarriageReturn(character) || HeaderUtils.isSpace(character) || HeaderUtils.isLineFeed(character) || HeaderUtils.isHorizontalTab(character);
    }

    public static boolean isLineFeed(int character) {
        return character == 10;
    }

    public static boolean isLowerCase(int character) {
        return character >= 97 && character <= 122;
    }

    public static boolean isQuoteCharacter(int character) {
        return character == 92;
    }

    public static boolean isQuotedText(int character) {
        return HeaderUtils.isText(character) && !HeaderUtils.isDoubleQuote(character);
    }

    public static boolean isSemiColon(int character) {
        return character == 59;
    }

    public static boolean isSeparator(int character) {
        switch (character) {
            case 9: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpace(int character) {
        return character == 32;
    }

    public static boolean isText(int character) {
        return HeaderUtils.isLatin1Char(character) && !HeaderUtils.isControlChar(character);
    }

    public static boolean isToken(CharSequence token) {
        for (int i = 0; i < token.length(); ++i) {
            if (HeaderUtils.isTokenChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTokenChar(int character) {
        return HeaderUtils.isAsciiChar(character) && !HeaderUtils.isSeparator(character);
    }

    public static boolean isUpperCase(int character) {
        return character >= 65 && character <= 90;
    }

    public static void writeCRLF(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    public static void writeHeaderLine(Header header, OutputStream os) throws IOException {
        os.write(StringUtils.getAsciiBytes(header.getName()));
        os.write(58);
        os.write(32);
        if (header.getValue() != null) {
            os.write(StringUtils.getLatin1Bytes(header.getValue()));
        }
        os.write(13);
        os.write(10);
    }

    private HeaderUtils() {
    }
}

