/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class MeanMetric
extends Metric {
    private String columnName;
    private double doubleSum;
    private long longSum;
    private long count;

    public MeanMetric(String columnName) {
        this.init("avg", columnName, false);
    }

    public MeanMetric(String columnName, boolean outputLong) {
        this.init("avg", columnName, outputLong);
    }

    public MeanMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        String outputLong = factory.getValueOperand(expression, 1);
        if (null == columnName) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        boolean ol = false;
        if (outputLong != null) {
            ol = Boolean.parseBoolean(outputLong);
        }
        this.init(functionName, columnName, ol);
    }

    private void init(String functionName, String columnName, boolean outputLong) {
        this.columnName = columnName;
        this.outputLong = outputLong;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public void update(Tuple tuple) {
        ++this.count;
        Object o = tuple.get(this.columnName);
        if (o instanceof Double) {
            Double d = (Double)tuple.get(this.columnName);
            this.doubleSum += d.doubleValue();
        } else {
            Long l = (Long)tuple.get(this.columnName);
            this.longSum += l.longValue();
        }
    }

    @Override
    public Metric newInstance() {
        return new MeanMetric(this.columnName, this.outputLong);
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public Number getValue() {
        double dcount = this.count;
        if (this.longSum == 0L) {
            return this.doubleSum / dcount;
        }
        double mean = (double)this.longSum / dcount;
        if (this.outputLong) {
            return Math.round(mean);
        }
        return mean;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName).withParameter(Boolean.toString(this.outputLong));
    }
}

