/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;

public class Violation
implements MapWriter {
    final String shard;
    final String coll;
    final String node;
    final Object actualVal;
    final Long replicaCountDelta;
    final Object tagKey;
    private final int hash;
    private final Clause clause;
    private List<ReplicaInfoAndErr> replicaInfoAndErrs = new ArrayList<ReplicaInfoAndErr>();

    Violation(Clause clause, String coll, String shard, String node, Object actualVal, Long replicaCountDelta, Object tagKey) {
        this.clause = clause;
        this.shard = shard;
        this.coll = coll;
        this.node = node;
        this.replicaCountDelta = replicaCountDelta;
        this.actualVal = actualVal;
        this.tagKey = tagKey;
        this.hash = ("" + coll + " " + shard + " " + node + " " + String.valueOf(tagKey) + " " + Utils.toJSONString(this.getClause().toMap(new HashMap<String, Object>()))).hashCode();
    }

    public Violation addReplica(ReplicaInfoAndErr r) {
        this.replicaInfoAndErrs.add(r);
        return this;
    }

    public List<ReplicaInfoAndErr> getViolatingReplicas() {
        return this.replicaInfoAndErrs;
    }

    public Clause getClause() {
        return this.clause;
    }

    public boolean matchShard(String shard) {
        if (this.getClause().shard.op == Operand.WILDCARD) {
            return true;
        }
        return this.shard == null || this.shard.equals(shard);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isLessSerious(Violation that) {
        return that.replicaCountDelta != null && this.replicaCountDelta != null && Math.abs(this.replicaCountDelta) < Math.abs(that.replicaCountDelta);
    }

    public boolean equals(Object that) {
        if (that instanceof Violation) {
            Violation v = (Violation)that;
            return Objects.equals(this.shard, v.shard) && Objects.equals(this.coll, v.coll) && Objects.equals(this.node, v.node) && Objects.equals(this.tagKey, v.tagKey);
        }
        return false;
    }

    public String toString() {
        return Utils.toJSONString(Utils.getDeepCopy(this.toMap(new LinkedHashMap<String, Object>()), 5));
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.putIfNotNull("collection", this.coll);
        ew.putIfNotNull("shard", this.shard);
        ew.putIfNotNull("node", this.node);
        ew.putIfNotNull("tagKey", String.valueOf(this.tagKey));
        ew.putIfNotNull("violation", ew1 -> {
            if (this.getClause().isPerCollectiontag()) {
                ew1.put("replica", this.actualVal);
            } else {
                ew1.put(this.clause.tag.name, String.valueOf(this.actualVal));
            }
            ew1.putIfNotNull("delta", this.replicaCountDelta);
        });
        ew.put("clause", this.getClause());
    }

    static class ReplicaInfoAndErr
    implements MapWriter {
        final ReplicaInfo replicaInfo;
        Long delta;

        ReplicaInfoAndErr(ReplicaInfo replicaInfo) {
            this.replicaInfo = replicaInfo;
        }

        public ReplicaInfoAndErr withDelta(Long delta) {
            this.delta = delta;
            return this;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put("replica", this.replicaInfo);
            ew.putIfNotNull("delta", this.delta);
        }
    }
}

