/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Matrix
implements Iterable {
    private double[][] data;
    private Map context = new HashMap();

    public Matrix(double[][] data) {
        this.data = data;
    }

    public Map getContext() {
        return this.context;
    }

    public void addToContext(Object key, Object value) {
        this.context.put(key, value);
    }

    public Object getContextValue(Object key) {
        return this.context.get(key);
    }

    public double[][] getData() {
        return this.data;
    }

    public Iterator iterator() {
        return new MatrixIterator(this.data);
    }

    private static class MatrixIterator
    implements Iterator {
        private double[][] d;
        private int index;

        public MatrixIterator(double[][] data) {
            this.d = data;
        }

        public Object next() {
            double[] row = this.d[this.index++];
            ArrayList<Double> list = new ArrayList<Double>();
            for (double value : row) {
                list.add(value);
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.d.length;
        }
    }
}

