/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.AC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AC3TrackImpl
extends AbstractTrack {
    static int[][][][] bitRateAndFrameSizeTable = new int[19][2][3][2];
    private final DataSource dataSource;
    private List<Sample> samples;
    private long[] duration;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private SampleDescriptionBox sampleDescriptionBox;

    static {
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][0][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][0][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][0][1] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][0][1] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][0][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][0][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][0][1] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][0][1] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][0][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][0][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][0][1] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][0][1] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][0][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][0][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][0][1] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][0][1] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][0][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][0][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][0][1] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][0][1] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][0][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][0][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][0][1] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][0][1] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][0][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][0][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][0][1] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][0][1] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][0][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][0][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][0][1] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][0][1] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][0][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][0][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][0][1] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][0][1] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][0][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][0][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][0][1] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][0][1] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][0][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][0][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][0][1] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][0][1] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][0][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][0][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][0][1] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][0][1] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][0][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][0][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][0][1] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][0][1] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][0][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][0][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][0][1] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][0][1] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][0][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][0][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][0][1] = 768;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][0][1] = 768;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][0][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][0][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][0][1] = 896;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][0][1] = 896;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][0][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][0][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][0][1] = 1024;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][0][1] = 1024;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][0][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][0][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][0][1] = 1152;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][0][1] = 1152;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][0][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][0][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][0][1] = 1280;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][0][1] = 1280;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][1][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][1][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][1][1] = 69;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][1][1] = 70;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][1][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][1][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][1][1] = 87;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][1][1] = 88;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][1][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][1][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][1][1] = 104;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][1][1] = 105;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][1][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][1][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][1][1] = 121;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][1][1] = 122;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][1][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][1][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][1][1] = 139;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][1][1] = 140;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][1][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][1][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][1][1] = 174;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][1][1] = 175;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][1][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][1][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][1][1] = 208;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][1][1] = 209;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][1][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][1][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][1][1] = 243;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][1][1] = 244;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][1][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][1][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][1][1] = 278;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][1][1] = 279;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][1][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][1][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][1][1] = 348;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][1][1] = 349;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][1][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][1][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][1][1] = 417;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][1][1] = 418;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][1][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][1][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][1][1] = 487;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][1][1] = 488;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][1][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][1][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][1][1] = 557;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][1][1] = 558;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][1][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][1][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][1][1] = 696;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][1][1] = 697;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][1][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][1][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][1][1] = 835;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][1][1] = 836;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][1][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][1][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][1][1] = 975;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][1][1] = 975;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][1][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][1][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][1][1] = 1114;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][1][1] = 1115;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][1][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][1][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][1][1] = 1253;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][1][1] = 1254;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][1][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][1][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][1][1] = 1393;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][1][1] = 1394;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][2][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][2][0] = 32;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][0][2][1] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[0][1][2][1] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][2][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][2][0] = 40;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][0][2][1] = 120;
        AC3TrackImpl.bitRateAndFrameSizeTable[1][1][2][1] = 120;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][2][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][2][0] = 48;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][0][2][1] = 144;
        AC3TrackImpl.bitRateAndFrameSizeTable[2][1][2][1] = 144;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][2][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][2][0] = 56;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][0][2][1] = 168;
        AC3TrackImpl.bitRateAndFrameSizeTable[3][1][2][1] = 168;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][2][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][2][0] = 64;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][0][2][1] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[4][1][2][1] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][2][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][2][0] = 80;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][0][2][1] = 240;
        AC3TrackImpl.bitRateAndFrameSizeTable[5][1][2][1] = 240;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][2][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][2][0] = 96;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][0][2][1] = 288;
        AC3TrackImpl.bitRateAndFrameSizeTable[6][1][2][1] = 288;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][2][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][2][0] = 112;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][0][2][1] = 336;
        AC3TrackImpl.bitRateAndFrameSizeTable[7][1][2][1] = 336;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][2][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][2][0] = 128;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][0][2][1] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[8][1][2][1] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][2][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][2][0] = 160;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][0][2][1] = 480;
        AC3TrackImpl.bitRateAndFrameSizeTable[9][1][2][1] = 480;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][2][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][2][0] = 192;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][0][2][1] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[10][1][2][1] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][2][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][2][0] = 224;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][0][2][1] = 672;
        AC3TrackImpl.bitRateAndFrameSizeTable[11][1][2][1] = 672;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][2][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][2][0] = 256;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][0][2][1] = 768;
        AC3TrackImpl.bitRateAndFrameSizeTable[12][1][2][1] = 768;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][2][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][2][0] = 320;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][0][2][1] = 960;
        AC3TrackImpl.bitRateAndFrameSizeTable[13][1][2][1] = 960;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][2][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][2][0] = 384;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][0][2][1] = 1152;
        AC3TrackImpl.bitRateAndFrameSizeTable[14][1][2][1] = 1152;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][2][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][2][0] = 448;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][0][2][1] = 1344;
        AC3TrackImpl.bitRateAndFrameSizeTable[15][1][2][1] = 1344;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][2][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][2][0] = 512;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][0][2][1] = 1536;
        AC3TrackImpl.bitRateAndFrameSizeTable[16][1][2][1] = 1536;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][2][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][2][0] = 576;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][0][2][1] = 1728;
        AC3TrackImpl.bitRateAndFrameSizeTable[17][1][2][1] = 1728;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][2][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][2][0] = 640;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][0][2][1] = 1920;
        AC3TrackImpl.bitRateAndFrameSizeTable[18][1][2][1] = 1920;
    }

    public AC3TrackImpl(DataSource dataSource) throws IOException {
        this(dataSource, "eng");
    }

    public AC3TrackImpl(DataSource dataSource, String lang) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.trackMetaData.setLanguage(lang);
        this.samples = this.readSamples();
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry ase = this.createAudioSampleEntry();
        this.sampleDescriptionBox.addBox(ase);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(lang);
        this.trackMetaData.setTimescale(ase.getSampleRate());
        this.trackMetaData.setVolume(1.0f);
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public synchronized long[] getSampleDurations() {
        return this.duration;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private AudioSampleEntry createAudioSampleEntry() throws IOException {
        int samplerate;
        ByteBuffer bb = this.samples.get(0).asByteBuffer();
        BitReaderBuffer brb = new BitReaderBuffer(bb);
        int syncword = brb.readBits(16);
        if (syncword != 2935) {
            throw new RuntimeException("Stream doesn't seem to be AC3");
        }
        brb.readBits(16);
        int fscod = brb.readBits(2);
        switch (fscod) {
            case 0: {
                samplerate = 48000;
                break;
            }
            case 1: {
                samplerate = 44100;
                break;
            }
            case 2: {
                samplerate = 32000;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Sample Rate");
            }
        }
        int frmsizecod = brb.readBits(6);
        int bsid = brb.readBits(5);
        int bsmod = brb.readBits(3);
        int acmod = brb.readBits(3);
        if (bsid == 16) {
            throw new RuntimeException("You cannot read E-AC-3 track with AC3TrackImpl.class - user EC3TrackImpl.class");
        }
        if (bsid == 9) {
            samplerate /= 2;
        } else if (bsid != 8 && bsid != 6) {
            throw new RuntimeException("Unsupported bsid");
        }
        if (acmod != 1 && (acmod & 1) == 1) {
            brb.readBits(2);
        }
        if ((acmod & 4) != 0) {
            brb.readBits(2);
        }
        if (acmod == 2) {
            brb.readBits(2);
        }
        switch (acmod) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported acmod");
            }
        }
        int lfeon = brb.readBits(1);
        if (lfeon == 1) {
            // empty if block
        }
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry("ac-3");
        audioSampleEntry.setChannelCount(2);
        audioSampleEntry.setSampleRate(samplerate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        AC3SpecificBox ac3 = new AC3SpecificBox();
        ac3.setAcmod(acmod);
        ac3.setBitRateCode(frmsizecod >> 1);
        ac3.setBsid(bsid);
        ac3.setBsmod(bsmod);
        ac3.setFscod(fscod);
        ac3.setLfeon(lfeon);
        ac3.setReserved(0);
        audioSampleEntry.addBox(ac3);
        return audioSampleEntry;
    }

    private int getFrameSize(int code, int fscod) {
        int frmsizecode = code >>> 1;
        int flag = code & 1;
        if (frmsizecode > 18 || flag > 1 || fscod > 2) {
            throw new RuntimeException("Cannot determine framesize of current sample");
        }
        return 2 * bitRateAndFrameSizeTable[frmsizecode][flag][fscod][1];
    }

    private List<Sample> readSamples() throws IOException {
        ByteBuffer header = ByteBuffer.allocate(5);
        ArrayList<Sample> mysamples = new ArrayList<Sample>();
        while (-1 != this.dataSource.read(header)) {
            int frmsizecode = header.get(4) & 0x3F;
            int fscod = header.get(4) >> 6;
            int frameSize = this.getFrameSize(frmsizecode, fscod);
            class SampleImpl
            implements Sample {
                private final long start;
                private final long size;
                private final DataSource dataSource;

                public SampleImpl(long start, long size, DataSource dataSource) {
                    this.start = start;
                    this.size = size;
                    this.dataSource = dataSource;
                }

                public void writeTo(WritableByteChannel channel) throws IOException {
                    this.dataSource.transferTo(this.start, this.size, channel);
                }

                public long getSize() {
                    return this.size;
                }

                public ByteBuffer asByteBuffer() {
                    try {
                        return this.dataSource.map(this.start, this.size);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            mysamples.add(new SampleImpl(this.dataSource.position() - 5L, frameSize, this.dataSource));
            this.dataSource.position(this.dataSource.position() - 5L + (long)frameSize);
            header.rewind();
        }
        this.duration = new long[mysamples.size()];
        Arrays.fill(this.duration, 1536L);
        return mysamples;
    }
}

