/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.FieldOptions;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

public class TermVectorComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "tv";
    public static final String TERM_VECTORS = "termVectors";
    private static final String TV_KEY_WARNINGS = "warnings";
    protected NamedList initParams;

    private Set<String> getFields(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        String[] fldLst = params.getParams("tv.fl");
        if (null == fldLst || 0 == fldLst.length || 1 == fldLst.length && 0 == fldLst[0].length()) {
            SolrReturnFields rf = new SolrReturnFields(params.getParams("fl"), rb.req);
            if (((ReturnFields)rf).wantsAllFields()) {
                return null;
            }
            Set<String> fieldNames = ((ReturnFields)rf).getLuceneFieldNames();
            return null != fieldNames ? fieldNames : Collections.emptySet();
        }
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (String fl : fldLst) {
            fieldNames.addAll(Arrays.asList(SolrPluginUtils.split(fl)));
        }
        return fieldNames;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        DocIterator iter;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        NamedList termVectors = new NamedList();
        rb.rsp.add(TERM_VECTORS, termVectors);
        IndexSchema schema = rb.req.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        String uniqFieldName = null;
        if (keyField != null) {
            uniqFieldName = keyField.getName();
        }
        FieldOptions allFields = new FieldOptions();
        allFields.termFreq = params.getBool("tv.tf", false);
        allFields.positions = params.getBool("tv.positions", false);
        allFields.offsets = params.getBool("tv.offsets", false);
        allFields.payloads = params.getBool("tv.payloads", false);
        allFields.docFreq = params.getBool("tv.df", false);
        allFields.tfIdf = params.getBool("tv.tf_idf", false);
        if (params.getBool("tv.all", false)) {
            allFields.termFreq = true;
            allFields.positions = true;
            allFields.offsets = true;
            allFields.payloads = true;
            allFields.docFreq = true;
            allFields.tfIdf = true;
        }
        HashMap<String, FieldOptions> fieldOptions = new HashMap<String, FieldOptions>();
        NamedList warnings = new NamedList();
        ArrayList<String> noTV = new ArrayList<String>();
        ArrayList<String> noPos = new ArrayList<String>();
        ArrayList<String> noOff = new ArrayList<String>();
        ArrayList<String> noPay = new ArrayList<String>();
        Set<String> fields = this.getFields(rb);
        if (null != fields) {
            for (String field : fields) {
                if (null == field || "score".equals(field)) continue;
                boolean fieldIsUniqueKey = field.equals(uniqFieldName);
                SchemaField sf = schema.getFieldOrNull(field);
                if (sf != null) {
                    if (sf.storeTermVector()) {
                        FieldOptions option = (FieldOptions)fieldOptions.get(field);
                        if (option == null) {
                            option = new FieldOptions();
                            option.fieldName = field;
                            fieldOptions.put(field, option);
                        }
                        option.termFreq = params.getFieldBool(field, "tv.tf", allFields.termFreq);
                        option.docFreq = params.getFieldBool(field, "tv.df", allFields.docFreq);
                        option.tfIdf = params.getFieldBool(field, "tv.tf_idf", allFields.tfIdf);
                        option.positions = params.getFieldBool(field, "tv.positions", allFields.positions);
                        if (option.positions && !sf.storeTermPositions() && !fieldIsUniqueKey) {
                            noPos.add(field);
                        }
                        option.offsets = params.getFieldBool(field, "tv.offsets", allFields.offsets);
                        if (option.offsets && !sf.storeTermOffsets() && !fieldIsUniqueKey) {
                            noOff.add(field);
                        }
                        option.payloads = params.getFieldBool(field, "tv.payloads", allFields.payloads);
                        if (!option.payloads || sf.storeTermPayloads() || fieldIsUniqueKey) continue;
                        noPay.add(field);
                        continue;
                    }
                    if (fieldIsUniqueKey) continue;
                    noTV.add(field);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: " + field);
            }
        }
        if (!noTV.isEmpty()) {
            warnings.add("noTermVectors", noTV);
        }
        if (!noPos.isEmpty()) {
            warnings.add("noPositions", noPos);
        }
        if (!noOff.isEmpty()) {
            warnings.add("noOffsets", noOff);
        }
        if (!noPay.isEmpty()) {
            warnings.add("noPayloads", noPay);
        }
        if (warnings.size() > 0) {
            termVectors.add(TV_KEY_WARNINGS, (Object)warnings);
        }
        DocListAndSet listAndSet = rb.getResults();
        List<Integer> docIds = this.getInts(params.getParams("tv.docIds"));
        if (docIds != null && !docIds.isEmpty()) {
            iter = docIds.iterator();
        } else {
            DocList list = listAndSet.docList;
            iter = list.iterator();
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        DirectoryReader reader = searcher.getIndexReader();
        final String finalUniqFieldName = uniqFieldName;
        final ArrayList uniqValues = new ArrayList();
        StoredFieldVisitor getUniqValue = new StoredFieldVisitor(){

            public void stringField(FieldInfo fieldInfo, byte[] bytes) {
                uniqValues.add(new String(bytes, StandardCharsets.UTF_8));
            }

            public void intField(FieldInfo fieldInfo, int value) {
                uniqValues.add(Integer.toString(value));
            }

            public void longField(FieldInfo fieldInfo, long value) {
                uniqValues.add(Long.toString(value));
            }

            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
                return fieldInfo.name.equals(finalUniqFieldName) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
            }
        };
        while (iter.hasNext()) {
            TermsEnum termsEnum;
            Integer docId = (Integer)iter.next();
            NamedList docNL = new NamedList();
            if (keyField != null) {
                reader.document(docId.intValue(), getUniqValue);
                Object uniqVal = null;
                if (uniqValues.size() != 0) {
                    uniqVal = (String)uniqValues.get(0);
                    uniqValues.clear();
                    docNL.add("uniqueKey", uniqVal);
                    termVectors.add((String)uniqVal, (Object)docNL);
                }
            } else {
                termVectors.add("doc-" + docId, (Object)docNL);
            }
            if (null != fields) {
                for (Map.Entry entry : fieldOptions.entrySet()) {
                    String field = (String)entry.getKey();
                    Terms vector = reader.getTermVector(docId.intValue(), field);
                    if (vector == null) continue;
                    termsEnum = vector.iterator();
                    this.mapOneVector((NamedList<Object>)docNL, (FieldOptions)entry.getValue(), (IndexReader)reader, docId, termsEnum, field);
                }
                continue;
            }
            Fields vectors = reader.getTermVectors(docId.intValue());
            for (String field : vectors) {
                Terms terms = vectors.terms(field);
                if (terms == null) continue;
                termsEnum = terms.iterator();
                this.mapOneVector((NamedList<Object>)docNL, allFields, (IndexReader)reader, docId, termsEnum, field);
            }
        }
    }

    private void mapOneVector(NamedList<Object> docNL, FieldOptions fieldOptions, IndexReader reader, int docID, TermsEnum termsEnum, String field) throws IOException {
        BytesRef text;
        NamedList fieldNL = new NamedList();
        docNL.add(field, (Object)fieldNL);
        PostingsEnum dpEnum = null;
        while ((text = termsEnum.next()) != null) {
            String term = text.utf8ToString();
            NamedList termInfo = new NamedList();
            fieldNL.add(term, (Object)termInfo);
            int freq = (int)termsEnum.totalTermFreq();
            if (fieldOptions.termFreq) {
                termInfo.add("tf", (Object)freq);
            }
            int dpEnumFlags = 0;
            dpEnumFlags |= fieldOptions.positions ? 24 : 0;
            dpEnumFlags |= fieldOptions.offsets || fieldOptions.payloads ? 56 : 0;
            dpEnum = termsEnum.postings(dpEnum, dpEnumFlags |= fieldOptions.payloads ? 88 : 0);
            boolean atNextDoc = false;
            if (dpEnum != null) {
                dpEnum.nextDoc();
                atNextDoc = true;
            }
            if (atNextDoc && dpEnumFlags != 0) {
                NamedList positionsNL = null;
                NamedList theOffsets = null;
                NamedList thePayloads = null;
                for (int i = 0; i < freq; ++i) {
                    BytesRef payload;
                    int startOffset;
                    int pos = dpEnum.nextPosition();
                    if (fieldOptions.positions && pos >= 0) {
                        if (positionsNL == null) {
                            positionsNL = new NamedList();
                            termInfo.add("positions", (Object)positionsNL);
                        }
                        positionsNL.add("position", (Object)pos);
                    }
                    int n = startOffset = fieldOptions.offsets ? dpEnum.startOffset() : -1;
                    if (startOffset >= 0) {
                        if (theOffsets == null) {
                            theOffsets = new NamedList();
                            termInfo.add("offsets", (Object)theOffsets);
                        }
                        theOffsets.add("start", (Object)dpEnum.startOffset());
                        theOffsets.add("end", (Object)dpEnum.endOffset());
                    }
                    BytesRef bytesRef = payload = fieldOptions.payloads ? dpEnum.getPayload() : null;
                    if (payload == null) continue;
                    if (thePayloads == null) {
                        thePayloads = new NamedList();
                        termInfo.add("payloads", (Object)thePayloads);
                    }
                    thePayloads.add("payload", (Object)Base64.byteArrayToBase64((byte[])payload.bytes, (int)payload.offset, (int)payload.length));
                }
            }
            int df = 0;
            if (fieldOptions.docFreq || fieldOptions.tfIdf) {
                df = reader.docFreq(new Term(field, text));
            }
            if (fieldOptions.docFreq) {
                termInfo.add("df", (Object)df);
            }
            if (!fieldOptions.tfIdf) continue;
            double tfIdfVal = (double)freq / (double)df;
            termInfo.add("tf-idf", (Object)tfIdfVal);
        }
    }

    private List<Integer> getInts(String[] vals) {
        ArrayList<Integer> result = null;
        if (vals != null && vals.length > 0) {
            result = new ArrayList<Integer>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                try {
                    result.add(new Integer(vals[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            NamedList termVectorsNL = new NamedList();
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x40) == 0 || !sreq.params.getBool(COMPONENT_NAME, false)) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList nl = (NamedList)srsp.getSolrResponse().getResponse().get(TERM_VECTORS);
                    Object warningsNL = nl.get(TV_KEY_WARNINGS);
                    if (warningsNL != null && termVectorsNL.indexOf(TV_KEY_WARNINGS, 0) < 0) {
                        termVectorsNL.add(TV_KEY_WARNINGS, warningsNL);
                    }
                    SolrPluginUtils.copyNamedListIntoArrayByDocPosInResponse(nl, rb.resultIds, arr);
                }
            }
            SolrPluginUtils.removeNulls(arr, termVectorsNL);
            rb.rsp.add(TERM_VECTORS, termVectorsNL);
        }
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if ((sreq.purpose & 0x40) == 0) {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Vectors";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }
}

