/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.transform.WriteableGeoJSON;
import org.apache.solr.search.ReturnFields;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.io.SupportedFormats;
import org.locationtech.spatial4j.shape.Shape;

class GeoJSONWriter
extends JSONWriter {
    final SupportedFormats formats;
    final ShapeWriter geowriter;
    final String geofield;

    public GeoJSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp, String geofield, SupportedFormats formats) {
        super(writer, req, rsp);
        this.geofield = geofield;
        this.formats = formats;
        this.geowriter = formats == null ? null : formats.getGeoJsonWriter();
    }

    @Override
    public void writeResponse() throws IOException {
        if (this.req.getParams().getBool("omitHeader", false)) {
            if (this.wrapperFunction != null) {
                this.writer.write(this.wrapperFunction + "(");
            }
            this.rsp.removeResponseHeader();
            NamedList vals = this.rsp.getValues();
            Object response = vals.remove("response");
            if (vals.size() != 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoJSON with omitHeader can not return more than a result set");
            }
            this.writeVal(null, response);
            if (this.wrapperFunction != null) {
                this.writer.write(')');
            }
            this.writer.write('\n');
        } else {
            super.writeResponse();
        }
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (idx > 0) {
            this.writeArraySeparator();
        }
        this.indent();
        this.writeMapOpener(-1);
        this.incLevel();
        this.writeKey("type", false);
        this.writeVal(null, "Feature");
        Object val = doc.getFieldValue(this.geofield);
        if (val != null) {
            this.writeFeatureGeometry(val);
        }
        boolean first = true;
        for (String fname : doc.getFieldNames()) {
            if (fname.equals(this.geofield) || returnFields != null && !returnFields.wantsField(fname)) continue;
            this.writeMapSeparator();
            if (first) {
                this.indent();
                this.writeKey("properties", false);
                this.writeMapOpener(-1);
                this.incLevel();
                first = false;
            }
            this.indent();
            this.writeKey(fname, true);
            val = doc.getFieldValue(fname);
            if (val instanceof List) {
                this.writeArray(name, ((Iterable)val).iterator());
                continue;
            }
            this.writeVal(fname, val);
        }
        if (doc.hasChildDocuments()) {
            if (!first) {
                this.writeMapSeparator();
                this.indent();
            }
            this.writeKey("_childDocuments_", true);
            this.writeArrayOpener(doc.getChildDocumentCount());
            List childDocs = doc.getChildDocuments();
            for (int i = 0; i < childDocs.size(); ++i) {
                this.writeSolrDocument(null, (SolrDocument)childDocs.get(i), null, i);
            }
            this.writeArrayCloser();
        }
        if (!first) {
            this.decLevel();
            this.writeMapCloser();
        }
        this.decLevel();
        this.writeMapCloser();
    }

    protected void writeFeatureGeometry(Object geo) throws IOException {
        if (geo instanceof Iterable) {
            Iterator iter = ((Iterable)geo).iterator();
            if (!iter.hasNext()) {
                return;
            }
            geo = iter.next();
            if (iter.hasNext()) {
                this.writeMapSeparator();
                this.indent();
                this.writeKey("geometry", false);
                this.incLevel();
                this.writeMapOpener(-1);
                this.writeKey("type", false);
                this.writeStr(null, "GeometryCollection", false);
                this.writeMapSeparator();
                this.writeKey("geometries", false);
                this.writeArrayOpener(-1);
                this.incLevel();
                this.indent();
                this.writeGeo(geo);
                while (iter.hasNext()) {
                    this.writeArraySeparator();
                    this.indent();
                    this.writeGeo(iter.next());
                }
                this.decLevel();
                this.writeArrayCloser();
                this.writeMapCloser();
                this.decLevel();
                return;
            }
        }
        if (geo != null) {
            this.writeMapSeparator();
            this.indent();
            this.writeKey("geometry", false);
            this.writeGeo(geo);
        }
    }

    protected void writeGeo(Object geo) throws IOException {
        Shape shape = null;
        String str = null;
        if (geo instanceof Shape) {
            shape = (Shape)geo;
        } else if (geo instanceof IndexableField) {
            str = ((IndexableField)geo).stringValue();
        } else if (geo instanceof WriteableGeoJSON) {
            shape = ((WriteableGeoJSON)geo).shape;
        } else {
            str = geo.toString();
        }
        if (str != null) {
            if (str.startsWith("{") && str.endsWith("}")) {
                this.writer.write(str);
                return;
            }
            if (this.formats == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoJSON unable to write field: '&geojson.field=" + this.geofield + "' (" + str + ")");
            }
            shape = this.formats.read(str);
        }
        if (this.geowriter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoJSON unable to write field: '&geojson.field=" + this.geofield + "'");
        }
        if (shape != null) {
            this.geowriter.write((Writer)this.writer, shape);
        }
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
        this.writeMapOpener(maxScore == null ? 3 : 4);
        this.incLevel();
        this.writeKey("type", false);
        this.writeStr(null, "FeatureCollection", false);
        this.writeMapSeparator();
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeMapSeparator();
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeMapSeparator();
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        this.writeMapSeparator();
        this.writeKey("features", false);
        this.writeArrayOpener(size);
        this.incLevel();
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.decLevel();
        this.writeArrayCloser();
        this.decLevel();
        this.indent();
        this.writeMapCloser();
    }
}

