/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.solr.search.facet.CountSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

class CountSlotArrAcc
extends CountSlotAcc {
    int[] result;

    public CountSlotArrAcc(FacetContext fcontext, int numSlots) {
        super(fcontext);
        this.result = new int[numSlots];
    }

    @Override
    public void collect(int doc, int slotNum) {
        int n = slotNum;
        this.result[n] = this.result[n] + 1;
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Integer.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        return this.result[slotNum];
    }

    @Override
    public void incrementCount(int slot, int count) {
        int n = slot;
        this.result[n] = this.result[n] + count;
    }

    @Override
    public int getCount(int slot) {
        return this.result[slot];
    }

    int[] getCountArray() {
        return this.result;
    }

    @Override
    public void reset() {
        Arrays.fill(this.result, 0);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        this.result = resizer.resize(this.result, 0);
    }
}

