/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.util.concurrent.Callable;
import org.apache.htrace.NullScope;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;
import org.apache.htrace.Tracer;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;
import org.apache.htrace.impl.MilliSpan;
import org.apache.htrace.impl.TrueIfTracingSampler;
import org.apache.htrace.wrappers.TraceCallable;
import org.apache.htrace.wrappers.TraceRunnable;

public class Trace {
    private static final Log LOG = LogFactory.getLog(Trace.class);

    public static TraceScope startSpan(String description) {
        return Trace.startSpan(description, TrueIfTracingSampler.INSTANCE);
    }

    public static TraceScope startSpan(String description, TraceInfo tinfo) {
        if (tinfo == null) {
            return Trace.continueSpan(null);
        }
        MilliSpan newSpan = new MilliSpan.Builder().begin(System.currentTimeMillis()).end(0L).description(description).traceId(tinfo.traceId).spanId(Tracer.nonZeroRandom64()).parents(new long[]{tinfo.spanId}).build();
        return Trace.continueSpan(newSpan);
    }

    public static TraceScope startSpan(String description, Span parent) {
        if (parent == null) {
            return Trace.startSpan(description);
        }
        Span currentSpan = Trace.currentSpan();
        if (currentSpan != null && currentSpan != parent) {
            Tracer.clientError("HTrace client error: thread " + Thread.currentThread().getName() + " tried to start a new Span " + "with parent " + parent.toString() + ", but there is already a " + "currentSpan " + currentSpan);
        }
        return Trace.continueSpan(parent.child(description));
    }

    public static <T> TraceScope startSpan(String description, Sampler<T> s) {
        return Trace.startSpan(description, s, null);
    }

    public static <T> TraceScope startSpan(String description, Sampler<T> s, T info) {
        Span span = null;
        if (Trace.isTracing() || s.next(info)) {
            span = Tracer.getInstance().createNew(description);
        }
        return Trace.continueSpan(span);
    }

    public static TraceScope continueSpan(Span s) {
        if (s == null) {
            return NullScope.INSTANCE;
        }
        return Tracer.getInstance().continueSpan(s);
    }

    public static void removeReceiver(SpanReceiver rcvr) {
        Tracer.getInstance().removeReceiver(rcvr);
    }

    public static void addReceiver(SpanReceiver rcvr) {
        Tracer.getInstance().addReceiver(rcvr);
    }

    public static void addKVAnnotation(byte[] key, byte[] value) {
        Span s = Trace.currentSpan();
        if (s != null) {
            s.addKVAnnotation(key, value);
        }
    }

    public static void addTimelineAnnotation(String msg) {
        Span s = Trace.currentSpan();
        if (s != null) {
            s.addTimelineAnnotation(msg);
        }
    }

    public static boolean isTracing() {
        return Tracer.getInstance().isTracing();
    }

    public static Span currentSpan() {
        return Tracer.getInstance().currentSpan();
    }

    public static <V> Callable<V> wrap(Callable<V> callable) {
        if (Trace.isTracing()) {
            return new TraceCallable<V>(Trace.currentSpan(), callable);
        }
        return callable;
    }

    public static Runnable wrap(Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(Trace.currentSpan(), runnable);
        }
        return runnable;
    }

    public static Runnable wrap(String description, Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(Trace.currentSpan(), runnable, description);
        }
        return runnable;
    }
}

