/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public final class LTRThreadModule
implements NamedListInitializedPlugin {
    private static String CONFIG_PREFIX = "threadModule.";
    private int totalPoolThreads = 1;
    private int numThreadsPerRequest = 1;
    private int maxPoolSize = Integer.MAX_VALUE;
    private long keepAliveTimeSeconds = 10L;
    private String threadNamePrefix = "ltrExecutor";
    private Semaphore ltrSemaphore;
    private Executor createWeightScoreExecutor;

    public static LTRThreadModule getInstance(NamedList args) {
        LTRThreadModule threadManager;
        NamedList threadManagerArgs = LTRThreadModule.extractThreadModuleParams(args);
        if (threadManagerArgs.size() > 0) {
            threadManager = new LTRThreadModule();
            threadManager.init(threadManagerArgs);
        } else {
            threadManager = null;
        }
        return threadManager;
    }

    private static NamedList extractThreadModuleParams(NamedList args) {
        NamedList extractedArgs = new NamedList();
        for (Map.Entry entry : args) {
            String key = (String)entry.getKey();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            extractedArgs.add(key.substring(CONFIG_PREFIX.length()), entry.getValue());
        }
        for (Object key : extractedArgs.asShallowMap().keySet()) {
            args.remove(CONFIG_PREFIX + key);
        }
        return extractedArgs;
    }

    public LTRThreadModule() {
    }

    LTRThreadModule(int totalPoolThreads, int numThreadsPerRequest) {
        this.totalPoolThreads = totalPoolThreads;
        this.numThreadsPerRequest = numThreadsPerRequest;
        this.init(null);
    }

    public void init(NamedList args) {
        if (args != null) {
            SolrPluginUtils.invokeSetters((Object)this, (Iterable)args);
        }
        this.validate();
        this.ltrSemaphore = this.totalPoolThreads > 1 ? new Semaphore(this.totalPoolThreads) : null;
        this.createWeightScoreExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, this.maxPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory(this.threadNamePrefix));
    }

    private void validate() {
        if (this.totalPoolThreads <= 0) {
            throw new IllegalArgumentException("totalPoolThreads cannot be less than 1");
        }
        if (this.numThreadsPerRequest <= 0) {
            throw new IllegalArgumentException("numThreadsPerRequest cannot be less than 1");
        }
        if (this.totalPoolThreads < this.numThreadsPerRequest) {
            throw new IllegalArgumentException("numThreadsPerRequest cannot be greater than totalPoolThreads");
        }
    }

    public void setTotalPoolThreads(int totalPoolThreads) {
        this.totalPoolThreads = totalPoolThreads;
    }

    public void setNumThreadsPerRequest(int numThreadsPerRequest) {
        this.numThreadsPerRequest = numThreadsPerRequest;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveTimeSeconds(long keepAliveTimeSeconds) {
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public Semaphore createQuerySemaphore() {
        return this.numThreadsPerRequest > 1 ? new Semaphore(this.numThreadsPerRequest) : null;
    }

    public void acquireLTRSemaphore() throws InterruptedException {
        this.ltrSemaphore.acquire();
    }

    public void releaseLTRSemaphore() throws InterruptedException {
        this.ltrSemaphore.release();
    }

    public void execute(Runnable command) {
        this.createWeightScoreExecutor.execute(command);
    }
}

