/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.SuppressForbidden;

@Documented
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface LogLevel {
    public String value();

    @SuppressForbidden(reason="Specific to Log4J")
    public static class Configurer {
        private static Map<String, Level> parseFrom(String input) {
            HashMap<String, Level> testlevels = new HashMap<String, Level>();
            for (String levelSetting : input.split(";")) {
                String[] parts = levelSetting.split("=");
                testlevels.put(parts[0], Level.toLevel((String)parts[1]));
            }
            return testlevels;
        }

        private static String levelAsString(Level level) {
            return level == null ? null : level.toString();
        }

        private static Level parseLevel(String level) {
            return level == null ? null : Level.toLevel((String)level);
        }

        public static void restoreLogLevels(Map<String, String> savedLogLevels) {
            savedLogLevels.forEach((name, level) -> {
                Logger logger = Logger.getLogger((String)name);
                logger.setLevel(Configurer.parseLevel(level));
            });
        }

        public static Map<String, String> setLevels(String value) {
            HashMap<String, String> oldLevels = new HashMap<String, String>();
            Configurer.parseFrom(value).forEach((name, level) -> {
                Logger logger = Logger.getLogger((String)name);
                oldLevels.put((String)name, Configurer.levelAsString(logger.getLevel()));
                logger.setLevel(level);
            });
            return oldLevels;
        }
    }
}

