'\"
'\" Generated from file 'plugin\&.inc' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "doctools::idx::export::json" n 0\&.1 tcllib "Documentation tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
doctools::idx::export::json \- JSON export plugin
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBdoctools::idx::export::json  ?0\&.1?\fR
.sp
package require \fBtextutil::adjust \fR
.sp
\fBexport\fR \fIserial\fR \fIconfiguration\fR
.sp
.BE
.SH DESCRIPTION
This package implements the doctools keyword index export plugin for
the generation of JSON markup\&.
.PP
This is an internal package of doctools, for use by the higher level
management packages handling keyword indices, especially \fBdoctools::idx::export\fR, the export manager\&.
.PP
Using it from a regular interpreter is possible, however only with
contortions, and is not recommended\&.
The proper way to use this functionality is through the package
\fBdoctools::idx::export\fR and the export manager objects it
provides\&.
.SH API
The API provided by this package satisfies the specification of the
docidx export plugin API version 2\&.
.TP
\fBexport\fR \fIserial\fR \fIconfiguration\fR
This command takes the canonical serialization of a keyword index, as
specified in section \fBKeyword index serialization format\fR,
and contained in \fIserial\fR, the \fIconfiguration\fR, a dictionary,
and generates JSON markup encoding the index\&.
The created string is then returned as the result of the command\&.
.PP
.SH "JSON NOTATION OF KEYWORD INDICES"
The JSON format used for keyword indices is a direct translation of
the \fBKeyword index serialization format\fR, mapping Tcl
dictionaries as JSON objects and Tcl lists as JSON arrays\&.
For example, the Tcl serialization
.CS


doctools::idx {
	label {Keyword Index}
	keywords {
		changelog  {changelog\&.man cvs\&.man}
		conversion {doctools\&.man docidx\&.man doctoc\&.man apps/dtplite\&.man mpexpand\&.man}
		cvs        cvs\&.man
	}
	references {
		apps/dtplite\&.man {manpage dtplite}
		changelog\&.man    {manpage doctools::changelog}
		cvs\&.man          {manpage doctools::cvs}
		docidx\&.man       {manpage doctools::idx}
		doctoc\&.man       {manpage doctools::toc}
		doctools\&.man     {manpage doctools}
		mpexpand\&.man     {manpage mpexpand}
	}
	title {}
}

.CE
is equivalent to the JSON string
.CS


{
    "doctools::idx" : {
        "label"      : "Keyword Index",
        "keywords"   : {
            "changelog"  : ["changelog\&.man","cvs\&.man"],
            "conversion" : ["doctools\&.man","docidx\&.man","doctoc\&.man","apps\\/dtplite\&.man","mpexpand\&.man"],
            "cvs"        : ["cvs\&.man"],
        },
        "references" : {
            "apps\\/dtplite\&.man" : ["manpage","dtplite"],
            "changelog\&.man"     : ["manpage","doctools::changelog"],
            "cvs\&.man"           : ["manpage","doctools::cvs"],
            "docidx\&.man"        : ["manpage","doctools::idx"],
            "doctoc\&.man"        : ["manpage","doctools::toc"],
            "doctools\&.man"      : ["manpage","doctools"],
            "mpexpand\&.man"      : ["manpage","mpexpand"]
        },
        "title"      : ""
    }
}

.CE
.SH CONFIGURATION
The JSON export plugin recognizes the following configuration
variables and changes its behaviour as they specify\&.
.TP
boolean \fIindented\fR
If this flag is set the plugin will break the generated JSON code
across lines and indent it according to its inner structure, with each
key of a dictionary on a separate line\&.
.sp
If this flag is not set (the default), the whole JSON object will be
written on a single line, with minimum spacing between all elements\&.
.TP
boolean \fIaligned\fR
If this flag is set the generator ensures that the values for the keys
in a dictionary are vertically aligned with each other, for a nice
table effect\&. To make this work this also implies that \fBindented\fR
is set\&.
.sp
If this flag is not set (the default), the output is formatted as per
the value of \fBindented\fR, without trying to align the values for
dictionary keys\&.
.PP
\fINote\fR that this plugin ignores the standard configuration
variables \fBuser\fR, \fBformat\fR, \fBfile\fR, and \fBmap\fR and
their values\&.
.SH "KEYWORD INDEX SERIALIZATION FORMAT"
Here we specify the format used by the doctools v2 packages to
serialize keyword indices as immutable values for transport,
comparison, etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&. While a keyword index may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.PP
.TP
regular serialization
.RS
.IP [1]
An index serialization is a nested Tcl dictionary\&.
.IP [2]
This dictionary holds a single key, \fBdoctools::idx\fR, and its
value\&. This value holds the contents of the index\&.
.IP [3]
The contents of the index are a Tcl dictionary holding the title of
the index, a label, and the keywords and references\&. The relevant keys
and their values are
.RS
.TP
\fBtitle\fR
The value is a string containing the title of the index\&.
.TP
\fBlabel\fR
The value is a string containing a label for the index\&.
.TP
\fBkeywords\fR
The value is a Tcl dictionary, using the keywords known to the index
as keys\&. The associated values are lists containing the identifiers of
the references associated with that particular keyword\&.
.sp
Any reference identifier used in these lists has to exist as a key in
the \fBreferences\fR dictionary, see the next item for its
definition\&.
.TP
\fBreferences\fR
The value is a Tcl dictionary, using the identifiers for the
references known to the index as keys\&. The associated values are
2-element lists containing the type and label of the reference, in
this order\&.
.sp
Any key here has to be associated with at least one keyword,
i\&.e\&. occur in at least one of the reference lists which are the values
in the \fBkeywords\fR dictionary, see previous item for its
definition\&.
.RE
.IP [4]
The \fItype\fR of a reference can be one of two values,
.RS
.TP
\fBmanpage\fR
The identifier of the reference is interpreted as symbolic file name,
refering to one of the documents the index was made for\&.
.TP
\fBurl\fR
The identifier of the reference is interpreted as an url, refering to
some external location, like a website, etc\&.
.RE
.RE
.TP
canonical serialization
The canonical serialization of a keyword index has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of the keyword index\&.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR\&.
.IP [2]
The references listed for each keyword of the index, if any, are
listed in ascending dictionary order of their \fIlabels\fR, as
generated by Tcl's builtin command \fBlsort -increasing -dict\fR\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdoctools\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
JSON, doctools, export, index, serialization
.SH CATEGORY
Text formatter plugin
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi